<?php

namespace Noptin\Addons_Pack\Custom_Fields\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Handles all custom field related actions.
 *
 * @since 2.0.0
 */
abstract class Abstract_Action extends \Noptin_Abstract_Action {

	/**
	 * @var string
	 */
	public $is_multiple = false;

	/**
	 * @var string
	 */
	public $label;

	/**
	 * @var string
	 */
	public $merge_tag;

	/**
	 * Constructor.
	 *
	 * @since 2.0.0
	 * @return string
	 */
	public function __construct( $merge_tag, $label ) {
		$this->category  = $this->is_multiple ? $label : __( 'Custom Fields', 'noptin-addons-pack' );
		$this->label     = $label;
		$this->merge_tag = $merge_tag;
	}

	/**
	 * @inheritdoc
	 */
	public function get_image() {
		return array(
			'icon' => $this->is_multiple ? 'category' : 'editor-table',
			'fill' => '#0073aa',
		);
	}

	/**
     * Returns an array of known field options.
     *
     * @since 2.0.0
     * @return array
     */
    public function get_options() {
		$custom_field = get_noptin_subscriber_smart_tag( $this->merge_tag );
		return empty( $custom_field['options'] ) ? array() : noptin_newslines_to_array( $custom_field['options'] );
	}

	/**
	 * @inheritdoc
	 */
	public function can_run( $subject, $rule, $args ) {

		// Abort if we do not have field name.
		if ( empty( $rule->action_settings[ $this->merge_tag ] ) ) {
			return false;
		}

		$email = $this->get_subject_email( $subject, $rule, $args );

		if ( empty( $email ) ) {
			return false;
		}

		$subscriber = noptin_get_subscriber( $email );

		return $subscriber->exists();
	}

	/**
	 * Fetches the current subscriber.
	 *
	 * @since 2.0.0
	 * @param mixed $subject The subject.
	 * @param \Noptin_Automation_Rule $rule The automation rule used to trigger the action.
	 * @param array $args Extra arguments passed to the action.
	 * @return \Hizzle\Noptin\DB\Subscriber
	 */
	public function get_subscriber( $subject, $rule, $args ) {
		return noptin_get_subscriber( $this->get_subject_email( $subject, $rule, $args ) );
	}
}
