<?php

namespace Noptin\Addons_Pack\Users\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Sets a user role.
 *
 * @since 1.10.0
 */
class Set_User_Role extends Add_User_Role {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'set_user_role';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Set Role', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'Sets the role of the user', 'noptin-addons-pack' );
	}

	/**
	 * @param \WP_User $user
	 * @param string $role
	 */
	protected function process( $user, $role ) {
		$user->set_role( $role );
	}
}
