<?php

namespace Stratum_Menu\Managers;

use \Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class ScriptsManager
 * @package Stratum_Menu
 */
class Scripts_Manager {

	private $version;
	private $prefix;

	/**
	 * ScriptsManager constructor.
	 */
	public function __construct() {

		$settings = \Stratum_Menu\Settings::get_instance();

		$this->version = $settings->getVersion();
		$this->prefix  = $settings->getPrefix();

		$this->init();
	}

	public function init() {
		//==============Actions==============

		if ( $this->check_elementor_plugin() ) {

			add_action( 'admin_enqueue_scripts', [ $this, 'register_fontawesome_denendencies' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_editor_menu_scripts' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_editor_admin_scripts' ] );

			//Editor
			add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'register_fontawesome_denendencies' ] );
			add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'register_widget_scripts_editor' ] );
			add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'register_widget_panel_editor' ] );

			//Frontend
			add_action( 'elementor/frontend/before_register_scripts', [ $this, 'register_scripts_dependencies' ] );
			add_action( 'elementor/frontend/before_register_styles' , [ $this, 'register_styles_dependencies' ] );
			add_action( 'elementor/frontend/after_enqueue_styles'   , [ $this, 'register_fontawesome_denendencies' ] );

			add_action( 'elementor/frontend/after_enqueue_styles' , [ $this, 'enqueue_frontend_styles'  ] );
			add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'enqueue_frontend_scripts' ] );
		}
	}

	/**
	 * Check if Elementor installed and activated.
	 */
	public function check_elementor_plugin() {
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'missing_elementor_plugin' ] );
			return false;
		} else {
			return true;
		}
	}

	// Admin notice.
	public function missing_elementor_plugin() {

		if ( isset( $_GET[ 'activate' ] ) ) unset( $_GET[ 'activate' ] );

		$message = sprintf(
			/* translators: 1: plugin name 2: plugin name */
			esc_html__( '%1$s requires %2$s plugin to be installed and activated.', 'stratum-menu' ),
			'Stratum Mega Menu',
			'Elementor'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	//Add the WP color picker CSS & JS assets
	public function enqueue_editor_menu_scripts() {

		if (is_admin() && get_current_screen()->id == 'nav-menus'){

			//Font Awesome
			wp_enqueue_style( 'font-awesome-5-all' );
			wp_enqueue_style( 'font-awesome-4-shim' );
			wp_enqueue_script( 'font-awesome-4-shim' );
			wp_enqueue_media();

			//Elementor select2
			wp_enqueue_style(
				'select2',
				stratum_menu_get_plugin_url( 'vendors/select2-4.0.13/css/select2.min.css' ),
				[],
				'4.0.13'
			);

			wp_enqueue_script(
				'jquery-select2',
				stratum_menu_get_plugin_url( 'vendors/select2-4.0.13/js/select2.full.min.js' ),
				[
					'jquery',
				],
				'4.0.13',
				true
			);

			//Color picker
			wp_enqueue_style( 'wp-color-picker' );

			wp_enqueue_style(
				"{$this->prefix}-editor-menu",
				stratum_menu_get_plugin_url( 'assets/css/editor-menu.min.css' ),
				apply_filters(
					'stratum-menu/editor_menu_css/dependencies',
					[]
				),
				$this->version
			);

			wp_enqueue_script(
				"{$this->prefix}-editor-menu-js",
				stratum_menu_get_plugin_url( 'assets/js/editor-menu.min.js' ),
				apply_filters(
					'stratum-menu/editor_menu_js/dependencies',
					[
						'jquery',
						'wp-color-picker',
						'jquery-select2'
					]
				),
				$this->version,
				true
			);

			wp_localize_script(
				"{$this->prefix}-editor-menu-js",
				'stratum_admin',
				apply_filters(
					'stratum-menu/editor_blocks_js/localize_data',
					[
						'ajax_url' => admin_url( 'admin-ajax.php' ),
					]
				)
			);

			wp_enqueue_script(
				"{$this->prefix}-editor-menu-image-js",
				stratum_menu_get_plugin_url( 'assets/js/editor-menu-image.min.js' ),
				apply_filters(
					'stratum-menu/editor_menu_image_js/dependencies',
					[
						'jquery',
					]
				),
				$this->version,
				true
			);

			wp_localize_script(
				"{$this->prefix}-editor-menu-image-js",
				'menuImage',
				[
					'l10n'     => [
						'uploaderTitle'      => __( 'Choose menu image', 'stratum-menu' ),
						'uploaderButtonText' => __( 'Select', 'stratum-menu' ),
					],
					'settings' => [
						'nonce' => wp_create_nonce( 'update-menu-item' ),
					],
				]
			);
		}

	}

	//Add the admin WP CSS & JS assets
	public function enqueue_editor_admin_scripts() {
		wp_enqueue_style(
			"{$this->prefix}-admin-panel-css",
			stratum_menu_get_plugin_url( 'assets/css/admin-panel.min.css' ),
			apply_filters(
				'stratum-menu/admin_panel_css/dependencies',
				[]
			),
			$this->version
		);

		wp_enqueue_script(
			"{$this->prefix}-admin-panel-js",
			stratum_menu_get_plugin_url( 'assets/js/admin-panel.min.js' ),
			apply_filters(
				'stratum-menu/admin_panel_js/dependencies',
				[
					'jquery',
				]
			),
			$this->version,
			true
		);
	}

	//JS load
	public function enqueue_frontend_scripts() {
		wp_enqueue_script(
			"{$this->prefix}-frontend-js",
			stratum_menu_get_plugin_url( 'assets/js/frontend.min.js' ),
			apply_filters(
				'stratum-menu/editor_blocks_js/dependencies',
				[
					'jquery'
				]
			),
			$this->version,
			true
		);
	}

	public function register_scripts_dependencies() {

	}

	//CSS load (in iframe)
	public function enqueue_frontend_styles() {
		wp_enqueue_style(
			"{$this->prefix}-widgets-style",
			stratum_menu_get_plugin_url( 'assets/css/style.min.css' ),
			apply_filters(
				'stratum-menu/frontend_css/dependencies',
				[
					// 'editor-preview'
				]
			),
			$this->version
		);
	}

	public function register_styles_dependencies() {
	}

	//Register fontawesome
	public function register_fontawesome_denendencies() {
		wp_register_script(
			'font-awesome-4-shim',
			ELEMENTOR_ASSETS_URL . 'lib/font-awesome/js/v4-shims.min.js',
			[],
			ELEMENTOR_VERSION
		);

		wp_register_style(
            'font-awesome-5-all',
            ELEMENTOR_ASSETS_URL . 'lib/font-awesome/css/all.min.css',
            false,
            ELEMENTOR_VERSION
		);

		wp_register_style(
			'font-awesome-4-shim',
			ELEMENTOR_ASSETS_URL . 'lib/font-awesome/css/v4-shims.min.css',
			[],
			ELEMENTOR_VERSION
		);
	}

	public function register_widget_scripts_editor() {
		wp_enqueue_script(
			"{$this->prefix}-editor-widgets-scripts",
			stratum_menu_get_plugin_url( 'assets/js/editor-widgets.min.js' ),
			[ 'jquery' ],
			$this->version,
			true
		);
	}

	public function register_widget_panel_editor() {
		wp_enqueue_style(
			"{$this->prefix}-editor-widgets-style",
			stratum_menu_get_plugin_url( 'assets/css/editor-widgets.min.css' ),
			[],
			$this->version
		);
	}

}
