<?php
if (!defined('ABSPATH')) exit;

$mpcePTAShortcodeFunctions = array(
			'mpce_pta_pricing_table' => 'mpcePTABoxShortcode',
			'mpce_pta_item' => 'mpcePTAItemShortcode'
	);

foreach ($mpcePTAShortcodeFunctions as $sortcode_name => $function_name) {
	add_shortcode($sortcode_name, $function_name);
}

$mpcePTAGeneralOptions = array();
$mpcePTAColCount = 1;

function mpcePTABoxShortcode($attrs, $content, $shortcodeName) {
	global $mpcePTAGeneralOptions, $mpcePTAColCount;
	$mpcePTAColCount = 1;
	$mp_style_classes = '';
	$dataAttr = '';
	$output = '';

	$defaultAttrs = array(
		'pta_featur_color' => '',
		'pta_price_bg_color' => '',
		'pta_price_color' => '',
		'pta_title_color' => '',
		'pta_alternative_color' => '',
		'pta_bg_color' => '',
		'pta_main_color' => '',

		'animation' => '',
		'border' => '',
		'border_color' => '',
		'border_radius' => 3,
		'pta_columns' => '', //cols count
		'no_wrap' => 'false',
		'mpce-pta-shadow' => 'false',
		'align' => 'mpce-pta-top',
	);
	$mpceActive = is_plugin_active('motopress-content-editor/motopress-content-editor.php') || is_plugin_active('motopress-content-editor-lite/motopress-content-editor.php');

	wp_enqueue_style('mpce-pta-style');
	wp_enqueue_script('mpce-pta-script');
	
	
	if ($mpceActive) $defaultAttrs = MPCEShortcode::addStyleAtts($defaultAttrs);
	extract(shortcode_atts($defaultAttrs, $attrs));

	$mpcePTAGeneralOptions = shortcode_atts($defaultAttrs, $attrs);

    $mpceClasses = '';
    if ($mpceActive) {
        if (!empty($mp_style_classes)) $mp_style_classes = ' ' . $mp_style_classes;
        $mpceClasses = MPCEShortcode::getBasicClasses('mpce_pta_pricing_table') . MPCEShortcode::getMarginClasses($margin) . $mp_style_classes;
		if (method_exists('MPCEShortcode', 'handleCustomStyles')) {
			$mpceClasses .= MPCEShortcode::handleCustomStyles($mp_custom_style, $shortcodeName, true);
		}
    }

	if(isContentEditor()){
		$dataAttr = ' data-cols="' . $pta_columns . '" data-wrap="' . $no_wrap .'" data-align="' . $align .'" ';
	}


	$output .= '<div class="' . $mpceClasses . ' "' . $dataAttr . ' ><div class="mp-row-fluid ' . $align .'">'
    . do_shortcode($content) . '</div></div>';

	return $output;
}


function mpcePTAItemShortcode($attrs, $content = null) {
	global $mpcePTAGeneralOptions, $mpcePTAColCount;
	$defaultAttrs = array(
		'title' => '',
		'subtitle' => '',
		'price_period' => '',
		'price_value' => '',
		'price_currency' => '',

		'button' => '',
		'link_text' => '',
        'woo_c' => '',
		'woo_text' => '',
		'link' => '',
		'script' => '',
		'selected' => '',

		'featur_color' => '',
		'price_bg_color' => '',
		'price_color' => '',
		'title_color' => '',
		'alternative_color' => '',
		'bg_color' => '',
		'main_color' => '',
	);
	extract( shortcode_atts($defaultAttrs, $attrs) );

    $output = '';
    $classes = '';

	$columns = $mpcePTAGeneralOptions['pta_columns'] !== '' ? $mpcePTAGeneralOptions['pta_columns'] : 1;
    $wrap = ( $mpcePTAGeneralOptions['no_wrap'] !== '' && $mpcePTAGeneralOptions['no_wrap'] !== 'false' ) ? true : false;
    $classes .= ( $mpcePTAGeneralOptions['animation'] !== '' && $mpcePTAGeneralOptions['animation'] !== 'none' ) ? ' ' . $mpcePTAGeneralOptions['animation'] : '';
    $classes .= ($selected !== '' && $selected === 'true') ?  ' mpce-pta-selected' : '';
    $classes .= ( $mpcePTAGeneralOptions['mpce-pta-shadow'] !== '' && $mpcePTAGeneralOptions['mpce-pta-shadow'] !== 'true' ) ? '' : ' mpce-pta-shadow';
	$border = $mpcePTAGeneralOptions['border'];

	$features = $content;
    $styles = array();

	/*Styles*/
    if( $border === 'solid' ){
        $border = '';
        if ( $mpcePTAGeneralOptions['border_color'] ) {
            $border .= 'border: 1px solid ' . $mpcePTAGeneralOptions['border_color']  . ';';
        }
        if ( $mpcePTAGeneralOptions['border_radius'] ) {
            $border .= 'border-radius: ' . $mpcePTAGeneralOptions['border_radius']  . 'px;';
        }
    } else {
		$border .= 'border: none;';
		$border .= 'border-radius: 0';
    }
	if ( !$main_color ){
		$main_color = $mpcePTAGeneralOptions['pta_main_color'];
	}
	if ( !$title_color ){
		$title_color = $mpcePTAGeneralOptions['pta_title_color'];
	}
	if ( !$price_color ){
		$price_color = $mpcePTAGeneralOptions['pta_price_color'];
	}
	if ( !$price_bg_color ){
		$price_bg_color = $mpcePTAGeneralOptions['pta_price_bg_color'];
	}
	if ( !$featur_color ){
		$featur_color = $mpcePTAGeneralOptions['pta_featur_color'];
	}
	if ( !$bg_color ){
		$bg_color = $mpcePTAGeneralOptions['pta_bg_color'];
	}
	if ( !$alternative_color ){
		$alternative_color = $mpcePTAGeneralOptions['pta_alternative_color'];
	}

    $styles['item'] = '';
    $styles['title'] = '';
    $styles['price'] = '';
    $styles['featur'] = '';
    $styles['link'] = '';
    $styles['item'] .= $featur_color !== '' ? ('color: ' . $featur_color . '; ') : '';
    $styles['item'] .= $bg_color !== '' ? ('background: ' . $bg_color . ';') : '';
    $styles['subtitle'] = $title_color !== '' ? ('color: ' . $title_color . ';') : '';
    $styles['title'] .= $title_color !== '' ? ('color: ' . $title_color . ';') : '';
    $styles['title'] .= $main_color !== '' ? ('background: ' . $main_color . ';') : '';
    $styles['price'] .= $price_color !== '' ? ('color: ' . $price_color . ';') : '';
    $styles['price'] .= $price_bg_color !== '' ? ('background: ' . $price_bg_color . ';') : '';
    $styles['featur'] .= $bg_color !== '' ? ('background: ' . $bg_color . ';') : '';
    $styles['featur'] .= $featur_color !== '' ? ('color: ' . $featur_color . '; ') : '';
    $styles['buttn'] = $bg_color !== '' ? ('background: ' . $bg_color . ';') : '';
    $styles['link'] .= $title_color !== '' ? ('color: ' . $title_color . ';') : '';
    $styles['link'] .= $main_color !== '' ? ('background: ' . $main_color . ';') : '';

	$price = '';
	if( $price_currency !== '' ){
		$price .= '<span class="mpce-pta-currency">' . $price_currency . '</span>';
	}
	if ( $price_value !== '' ) {
        $price .= '<span class="mpce-pta-price">' . $price_value . '</span>';
    }
    if ( $price_period !== '' ) {
		$price .= '<span class="mpce-pta-period">' . $price_period . '</span>';
	}

	if( $button === 'link' ){
		if( $link_text ){
			$button  = '<a class="" href="' . $link . '" style="' . $styles['link'] . '">' . $link_text . '</a>';
		} else {
			$button = '';
		}
	} elseif ( $button === 'script' ){
		if( $script ) {
			$button = base64_decode(strip_tags($script));
			$button = preg_replace('~[\r\n]~', '', $button);
		} else {
			$button = '';
		}
	} elseif ( $button === 'woo_c' ){
		if( $woo_c ) {
			$btn_text = new WooCommerceButtonClassPTA($woo_text);

			add_filter('woocommerce_product_add_to_cart_text', array(&$btn_text, 'getText'));    //  2.1+

			$button = '[add_to_cart id="' . $woo_c . '" show_price="false" style="' . $styles['link'] . ' "]';

			remove_filter('add_to_cart_text', array($btn_text, 'getText'));
		} else {
			$button = '';
		}
	} else {
		$button = '';
	}

	if( $wrap === true ) {
		$itemGridClass = 'mpce-pta-span' . ( 12 / $columns );
	} else {
		$itemGridClass = 'mp-span' . ( 12 / $columns );
	}

	$output .= '<div class="' . $itemGridClass . '">' .
		'<div class="mpce-pta-box-item' . $classes . '" style="' . $border . ' ' . $styles['item'] . '">';

	if ( $title !== '' || $subtitle !== '' )
		$output .=	'<div class="mpce-pta-title" style="' . $styles['title'] . '">';
	if ( $title !== '' )
		$output .=	'<h3 style="' . $styles['subtitle'] . '">' . $title . '</h3>';
	if ( $subtitle !== '' )
		$output .= '<div class="mpce-pta-subtitle" >' . $subtitle . '</div>';
	if ( $title !== '' || $subtitle !== '' )
        $output .= '</div>';

	if ( $price !== '' )
		$output .= '<div class="mpce-pta-price-box" style="' . $styles['price'] . '">' . $price . '</div>';
	if ( $features !== '' )
		$output .= '<div class="mpce-pta-features" data-odd_color="' . $alternative_color . '" style="' . $styles['featur'] . '">' . $features . '</div>' ;
	if ( $button !== '' ){
        $output .='<div class="mpce-pta-button" style="' . $styles['buttn'] . '">' . $button . '</div>';
    }
	$output .= 	'</div>'.
		'</div>';

	//genetate rows
	$isRowFull = ($mpcePTAColCount % $columns === 0);
    if ($isRowFull) {
        $output .= '</div>';
        $output .= '<div class="mp-row-fluid ' . $mpcePTAGeneralOptions['align' ] .'">';
    }

	$mpcePTAColCount++;

	return $output;
}

class WooCommerceButtonClassPTA {
	private $text;
	function __construct($btn_text){
		$this->text = $btn_text;
	}
	function getText(){
		return $this->text;
	}
	function getEmpty(){
		return '';
	}
}