<?php

add_action('mpce_add_simple_shortcode', 'mpcePTAAddSimpleShortcode');

function mpcePTAAddSimpleShortcode() {
	add_shortcode('mpce_pta_pricing_table', 'mpcePTABoxShortcodeSimple');
	add_shortcode('mpce_pta_item', 'mpcePTAItemShortcodeSimple');
}

$mpcePTAGeneralOptionsSimple = array();

function mpcePTABoxShortcodeSimple($attrs, $content = null) {
	global $mpcePTAGeneralOptionsSimple;
	$output = '';

	$defaultAttrs = array(
		'pta_featur_color' => '',
		'pta_price_bg_color' => '',
		'pta_price_color' => '',
		'pta_title_color' => '',
		'pta_alternative_color' => '',
		'pta_bg_color' => '',
		'pta_main_color' => '',

		'animation' => '',
		'border' => '',
		'border_color' => '',
		'border_radius' => 3,
		'pta_columns' => '', //cols count
		'no_wrap' => 'false',
		'mpce-pta-shadow' => 'false',
		'align' => 'mpce-pta-top',
	);

	$mpcePTAGeneralOptionsSimple = shortcode_atts($defaultAttrs, $attrs);

	$output .= do_shortcode($content);

	$mpcePTAGeneralOptionsSimple = array();

	return $output;
}


function mpcePTAItemShortcodeSimple($attrs, $content = null) {
	global $mpcePTAGeneralOptionsSimple;

	extract(shortcode_atts(array(
		'title' => '',
		'subtitle' => '',
		'price_period' => '',
		'price_value' => '',
		'price_currency' => '',

		'button' => '',
		'link_text' => '',
		'woo_c' => '',
		'woo_text' => '',
		'link' => '',
		'script' => '',
		'selected' => '',

		'featur_color' => '',
		'price_bg_color' => '',
		'price_color' => '',
		'title_color' => '',
		'alternative_color' => '',
		'bg_color' => '',
		'main_color' => '',
	), $attrs));

	$output = '';
	$border = $mpcePTAGeneralOptionsSimple['border'];
	$features = $content;
	$styles = array();

	/*Styles*/
	if ($border === 'solid') {
		$border = '';
		if ($mpcePTAGeneralOptionsSimple['border_color']) {
			$border .= 'border: 1px solid ' . $mpcePTAGeneralOptionsSimple['border_color'] . ';';
		}
		if ($mpcePTAGeneralOptionsSimple['border_radius']) {
			$border .= 'border-radius: ' . $mpcePTAGeneralOptionsSimple['border_radius'] . 'px;';
		}
	} else {
		$border .= 'border: none;';
		$border .= 'border-radius: 0';
	}
	if (!$main_color) {
		$main_color = $mpcePTAGeneralOptionsSimple['pta_main_color'];
	}
	if (!$title_color) {
		$title_color = $mpcePTAGeneralOptionsSimple['pta_title_color'];
	}
	if (!$price_color) {
		$price_color = $mpcePTAGeneralOptionsSimple['pta_price_color'];
	}
	if (!$price_bg_color) {
		$price_bg_color = $mpcePTAGeneralOptionsSimple['pta_price_bg_color'];
	}
	if (!$featur_color) {
		$featur_color = $mpcePTAGeneralOptionsSimple['pta_featur_color'];
	}
	if (!$bg_color) {
		$bg_color = $mpcePTAGeneralOptionsSimple['pta_bg_color'];
	}

	$styles['item'] = '';
	$styles['title'] = '';
	$styles['price'] = '';
	$styles['featur'] = '';
	$styles['link'] = '';
	$styles['item'] .= $featur_color !== '' ? ('color: ' . $featur_color . '; ') : '';
	$styles['item'] .= $bg_color !== '' ? ('background: ' . $bg_color . ';') : '';
	$styles['subtitle'] = $title_color !== '' ? ('color: ' . $title_color . ';') : '';
	$styles['title'] .= $title_color !== '' ? ('color: ' . $title_color . ';') : '';
	$styles['title'] .= $main_color !== '' ? ('background: ' . $main_color . ';') : '';
	$styles['price'] .= $price_color !== '' ? ('color: ' . $price_color . ';') : '';
	$styles['price'] .= $price_bg_color !== '' ? ('background: ' . $price_bg_color . ';') : '';
	$styles['featur'] .= $bg_color !== '' ? ('background: ' . $bg_color . ';') : '';
	$styles['featur'] .= $featur_color !== '' ? ('color: ' . $featur_color . '; ') : '';
	$styles['buttn'] = $bg_color !== '' ? ('background: ' . $bg_color . ';') : '';
	$styles['link'] .= $title_color !== '' ? ('color: ' . $title_color . ';') : '';
	$styles['link'] .= $main_color !== '' ? ('background: ' . $main_color . ';') : '';

	$price = '';
	if ($price_currency !== '') $price .= $price_currency;
	if ($price_value !== '') $price .= $price_value;
	if ($price_period !== '') $price .= $price_period;

	if ($button === 'link') {
		if ($link_text) {
			$button = '<a href="' . $link . '" style="' . $styles['link'] . '">' . $link_text . '</a>';
		} else {
			$button = '';
		}
	} elseif ($button === 'script') {
		if ($script) {
			$button = base64_decode(strip_tags($script));
			$button = preg_replace('~[\r\n]~', '', $button);
		} else {
			$button = '';
		}
	} elseif ($button === 'woo_c') {
		if ($woo_c) {
			$btn_text = new WooCommerceButtonClassPTA($woo_text);

			add_filter('woocommerce_product_add_to_cart_text', array(&$btn_text, 'getText'));    //  2.1+

			$button = '[add_to_cart id="' . $woo_c . '" show_price="false" style="' . $styles['link'] . ' "]';

			remove_filter('add_to_cart_text', array($btn_text, 'getText'));
		} else {
			$button = '';
		}
	} else {
		$button = '';
	}



	$output .= '<table style="' . $border . ' ' . $styles['item'] . '">';

	// Title
	$title = trim($title);
	$subtitle = trim($subtitle);
	if ($title !== '' || $subtitle !== '')
		$output .= '<tr style="' . $styles['title'] . '"><td>';
	if ($title !== '')
		$output .= '<h3 style="' . $styles['subtitle'] . '">' . $title . '</h3>';
	if ($subtitle !== '')
		$output .= "<p>{$subtitle}</p>";
	if ($title !== '' || $subtitle !== '')
		$output .= '</td></tr>';

	// Price
	if ($price !== '')
		$output .= '<tr style="' . $styles['price'] . '"><td>' . $price . '</td></tr>';

	// Features
	if ($features !== '')
		$output .= '<tr style="' . $styles['featur'] . '"><td>' . $features . '</td></tr>';

	// Button
	if ($button !== '') {
		$output .= '<tr style="' . $styles['buttn'] . '"><td>' . $button . '</td></tr>';
	}

	$output .= '</table>';
	return $output;
}