<?php

namespace Stratum_Menu;

if ( ! defined( 'ABSPATH' ) ) exit;

class Admin_Menu {
	public function __construct() {
		add_action( 'admin_menu', [ $this, 'stratum_register_admin_submenu' ], 20 );
	}

	public function stratum_register_admin_submenu() {
		add_submenu_page(
			'themes.php',
			__( 'Mega Menu', 'stratum-menu' ),
			__( 'Mega Menu', 'stratum-menu' ),
			'edit_theme_options',
			'stratum-menu-settings',
			[ $this, 'display_settings_content' ],
			4
		);
	}

	public function display_settings_content() {
		$licenseEnabled = \Stratum_Menu\Settings::get_instance()->isLicenseEnabled();
		?>
			<div id="stratum-wrap" class="wrap">
				<h1 class="wp-heading-inline"> <?php echo esc_html__( 'Stratum Mega Menu', 'stratum-menu' ); ?> </h1>
				<nav class="nav-tab-wrapper">
					<a href="#instruction" class="nav-tab nav-tab-active"><?php echo __( 'Instruction', 'stratum-menu' ); ?></a>
					<?php if ( $licenseEnabled ) { ?>
						<a href="#license" class="nav-tab"><?php echo __( 'License', 'stratum-menu' ); ?></a>
					<?php } ?>
				</nav>
				<div class="tab-content">
					<div class="tab-content-info tab-content-info-instruction tab-content-active">
						<?php
							if ( class_exists( '\Stratum_Menu\Instruction' ) ) {
								$instruction = \Stratum_Menu\Instruction::get_instance()->instruction_page();
								echo $instruction;
							}
						?>
					</div>
					<?php if ( $licenseEnabled ) { ?>
						<div class="tab-content-info tab-content-info-license">
							<?php
								if ( class_exists( '\Stratum_Menu\License\License' ) ) {
									$license = \Stratum_Menu\License\License::get_instance()->license_page();
									echo $license;
								}
							?>
						</div>
					<?php } ?>
				</div>
			</div>
		<?php
	}
}


new Admin_Menu();
