<?php

namespace Stratum_Menu\Managers;

use \Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class WidgetsManager
 * @package Stratum_Menu
 */
class Widgets_Manager {

	private $prefix;

	/**
	 * WidgetsManager constructor.
	 */
	public function __construct() {

		$settings = \Stratum_Menu\Settings::get_instance();
		$this->prefix  = $settings->getPrefix();

		add_filter( 'stratum_required_widgets', [ $this, 'add_widgets_to_stratum' ] );

		add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ], 12 );
		add_action( 'elementor/elements/categories_registered', [ $this, 'register_widgets_categories' ] );
	}

	//Group element under Theme slug
	public function register_widgets_categories() {
		if (!is_plugin_active( 'stratum/stratum.php' )){
			Plugin::instance()->elements_manager->add_category(
				'stratum-widgets',
				[
					'title'  => __( '<strong>Stratum</strong> Widgets', 'stratum-menu' ),
					'icon' => 'font'
				],
				0
			);
		}
	}

	public function add_widgets_to_stratum($widgets) {
		$mega_menu = array(
			array(
				'name'      => 'mega-menu',
				'label'     => esc_html__( 'Mega Menu', 'stratum-menu' ),
				'desc'      => esc_html__( 'Mega Menu', 'stratum-menu' ),
				'icon'      => 'eicon-nav-menu',
				'type'      => 'toggle',
				'default'   => 'on'
			),
			array(
				'name'      => 'menu',
				'label'     => esc_html__( 'Menu', 'stratum-menu' ),
				'desc'      => esc_html__( 'Menu', 'stratum-menu' ),
				'icon'      => 'eicon-nav-menu',
				'type'      => 'toggle',
				'default'   => 'on'
			)
		);
		return array_merge( $widgets, $mega_menu );
	}

	public function register_widgets() {

		require_once stratum_menu_get_plugin_path( '/includes/stratum-menu-widget-base.php' );

		if ( defined( 'ELEMENTOR_PATH' ) && class_exists( 'Elementor\Widget_Base' ) ) {

			if ( class_exists( 'Elementor\Plugin' ) ) {

				if ( is_callable( 'Elementor\Plugin', 'instance' ) ) {

					$elementor = Plugin::instance();

					if ( isset( $elementor->widgets_manager ) ) {

						if ( method_exists( $elementor->widgets_manager, 'register' ) ) {

							//Files widgets list
							$widgets_list = [];

							$stratum_get_widgets = get_option( 'stratum_widgets' );

							if ( empty( $stratum_get_widgets ) ) {
								//Get all files
								if ( $handle = opendir( stratum_menu_get_plugin_path( '/includes/widgets/' ) ) ) {
									while ( ( $file = readdir( $handle ) ) !== false ) {
										if ( $file != "." && $file != ".." ) {
											$widgets_list[] = str_replace( ".php", '', $file );
										}
									}
									closedir( $handle );
								}
							} else {
								foreach ( $stratum_get_widgets as $widget_name => $enabled ) {
									if ( $enabled == 'on' ) {
										$widgets_list[] = $widget_name;
									}
								}
							}

							foreach ($widgets_list as $key => $widget_name) {
								$path = stratum_menu_get_plugin_path( '/includes/widgets/' . $widget_name . '.php' );

								if ( file_exists( $path ) ) {
									require_once( $path );
								}
							}
						}
					}
				}
			}
		}
	}
}
