<?php

namespace Noptin\Addons_Pack\Custom_Fields\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a subscriber is added to a field.
 *
 * @since 2.0.0
 */
class Add_To_Field extends Abstract_Trigger {

	/**
	 * @var string
	 */
	public $is_multiple = true;

	/**
	 * @inheritdoc
	 */
	public function attach_hooks() {
		add_action( "noptin_subscriber_added_to_{$this->merge_tag}", array( $this, 'trigger_set' ), 10, 2 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'add_to_' . $this->merge_tag;
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Subscriber > Added to %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return sprintf(
			/* translators: %s: field label */
			__( 'When a subscriber is added to %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
     * Returns an array of known smart tags.
     *
     * @since 1.9.0
     * @return array
     */
    public function get_known_smart_tags() {

		return array_replace(
			array(
				'field_value' => array(
					'description'       => __( 'The new value', 'noptin-addons-pack' ),
					'example'           => 'field_value',
					'conditional_logic' => 'string',
					'options'           => $this->get_options(),
				),
				'field_name'  => array(
					'description'       => __( 'The new label', 'noptin-addons-pack' ),
					'example'           => 'field_name',
					'conditional_logic' => 'string',
				),
			),
			parent::get_known_smart_tags()
		);
	}

	/**
	 * Prepares email test data.
	 *
	 * @since 1.11.0
	 * @param Noptin_Automation_Rule $rule
	 * @return Noptin_Automation_Rules_Smart_Tags
	 * @throws Exception
	 */
	public function get_test_smart_tags( $rule ) {

		$subject = noptin_get_subscriber( get_current_noptin_subscriber_id() );
		$args    = $this->prepare_trigger_args(
			$subject,
			array(
				'field_value' => 'Sample Value',
				'field_name'  => 'Sample Label',
			)
		);

		return $args['smart_tags'];
	}

}
