<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Handles all user related triggers.
 *
 * @since 1.9.0
 */
abstract class Abstract_Trigger extends \Noptin_Abstract_Trigger {

	/**
     * Whether or not this trigger deals with a user.
     *
     * @var bool
     */
    public $is_user_based = true;

	/**
	 * @var string
	 */
	public $category = 'WordPress Users';

	/**
	 * @inheritdoc
	 */
	public function get_image() {
		return array(
			'icon' => 'admin-users',
			'fill' => '#404040',
		);
	}

}
