<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when there is a new WordPress user.
 *
 * @since 1.9.0
 */
class New_User extends Abstract_Trigger {

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct() {
		add_action( 'user_register', array( $this, 'maybe_trigger' ), 1000 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'new_user';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Create Account', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'When someone creates a new account', 'noptin-addons-pack' );
	}

	/**
	 * Called when someone creates a new account.
	 *
	 * @param int $user_id  User ID.
	 */
	public function maybe_trigger( $user_id ) {
		$user = get_userdata( $user_id );

		if ( ! $user ) {
			return;
		}

		$this->trigger( $user, array() );
	}

	/**
	 * Prepares email test data.
	 *
	 * @since 1.11.0
	 * @param Noptin_Automation_Rule $rule
	 * @return Noptin_Automation_Rules_Smart_Tags
	 * @throws Exception
	 */
	public function get_test_smart_tags( $rule ) {

		$user = wp_get_current_user();
		$args = $this->prepare_trigger_args( $user, array() );

		return $args['smart_tags'];
	}
}
