<?php
/**
 * Noptin Iframe.
 *
 */

defined( 'ABSPATH' ) || exit;

/**
 * Noptin Iframe.
 *
 */
class Noptin_Iframe {

	/**
	 * Class Constructor.
	 */
	public function __construct() {

		add_filter( 'noptin_actions_page_template', array( $this, 'filter_template' ), 10, 2 );
		add_filter( 'noptin_optin_form_editor_sidebar_section', array( $this, 'form_settings' ) );
		add_filter( 'noptin_optin_form_editor_state', array( $this, 'form_state' ), 10, 2 );
		add_action( 'noptin_form_editor_embed_metabox', array( $this, 'show_share_url' ) );

	}

	/**
	 * Filters the actions page template.
	 *
	 * @param string $template
	 * @param string $action
	 */
	public function filter_template( $template, $action ) {

		if ( 'embed' === $action ) {
			$template = plugin_dir_path( __FILE__ ) . 'template.php';
		}

		return $template;
	}

	/**
     * Registers custom form settings
     *
     * @access      public
     * @since       1.0.0
     * @return      array
     */
    public function form_settings( $settings ) {

        $settings['settings']['noptin_embed'] = array(
            'el'       => 'panel',
            'title'    => __( 'Embed', 'noptin-addons-pack' ),
			'restrict' => "this.optinType=='inpost'",
            'id'       => 'embedSettings',
            'children' => array(

				'embed_url'  => array(
					'type'     => 'text',
					'el'       => 'input',
					'label'    => __( 'Share URL', 'noptin-addons-pack' ),
					'restrict' => "this.optinType=='inpost'",
					'readonly' => 'readonly',
					'onclick'  => 'this.select()',
				),

				'embed_code' => array(
					'type'     => 'textarea',
					'el'       => 'textarea',
					'label'    => __( 'Embed Code', 'noptin-addons-pack' ),
					'restrict' => "this.optinType=='inpost'",
					'readonly' => 'readonly',
					'onclick'  => 'this.select()',
				),

            ),
        );

        return $settings;
    }

	/**
     * Filters form state
     *
     * @access      public
     * @since       1.0.0
     * @return      array
     */
    public function form_state( $state, $form ) {
		$state['embed_url']  = get_noptin_action_url( 'embed', $form->id );
		$state['embed_code'] = '<iframe src="' . get_noptin_action_url( 'embed', $form->id ) . '" style="border:none;height: 400px;width:100%;" title="Newsletter Subscribe"></iframe>';
		return $state;
	}

	/**
	 *
	 * @param int $post_id
	 */
	public function show_share_url( $post_id ) {

		?>

			<div class="noptin-text-wrapper">
				<label>
					<strong><?php echo esc_html_e( 'Share URL', 'noptin-addons-pack' ); ?></strong>
					<input type="text" value="<?php echo esc_url( get_noptin_action_url( 'embed', $post_id ) ); ?>" readonly="readonly" onclick="this.select()" style="width: 100%;" />
					<p class="description"><?php esc_html_e( 'You can share this URL with your social network followers.', 'noptin-addons-pack' ); ?></p>
				</label>
			</div>

			<div class="noptin-text-wrapper">
				<label>
					<strong><?php echo esc_html_e( 'Embed Code', 'noptin-addons-pack' ); ?></strong>
					<textarea rows="6" readonly="readonly" onclick="this.select()" style="width: 100%;"><?php echo esc_textarea( '<iframe src="' . get_noptin_action_url( 'embed', $post_id ) . '" style="border:none;height: 400px;width:100%;" title="Newsletter Subscribe"></iframe>' ); ?></textarea>
					<p class="description"><?php esc_html_e( 'Use this code to embed the form on another website.', 'noptin-addons-pack' ); ?></p>
				</label>
			</div>

		<?php
	}

}

new Noptin_Iframe();
