<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Gets plugin's absolute directory path.
 *
 * @param string $path Relative path
 *
 * @return string
 */
function stratum_menu_get_plugin_path( $path = '' ) {
	return STRATUM_MENU_PLUGIN_DIR . trim( $path, '/' );
}

/**
 * Gets plugin's URL.
 *
 * @param string $path
 *
 * @return string
 */
function stratum_menu_get_plugin_url( $path = '' ) {
	return plugins_url( $path, STRATUM_MENU_PLUGIN_FILE );
}

//Check if this Elementor page
function stratum_menu_is_elementor($id = '') {
	global $post;

	if (!empty($id)) {
		return \Elementor\Plugin::$instance->db->is_built_with_elementor($id);
	} else {
		return \Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID);
	}
}

function stratum_menu_get_menu_list(){
	$menu_objects = wp_get_nav_menus();
	$menus_list = wp_list_pluck( $menu_objects, 'name', 'term_id' );
	$parent_menu = isset( $_GET['parent_menu'] ) ? absint( $_GET['parent_menu'] ) : 0;

	if ( 0 < $parent_menu && isset( $menus_list[ $parent_menu ] ) ) {
		unset( $menus_list[ $parent_menu ] );
	}

	return !empty($menus_list) ? $menus_list : [];
}

function stratum_menu_css_class($class_array){
	return implode(' ', array_filter($class_array));
}

function stratum_menu_render_svg_icon( $value ) {
	if ( ! isset( $value[ 'id' ] ) ) {
		return '';
	}

	return \Elementor\Core\Files\Assets\Svg\Svg_Handler::get_inline_svg( $value[ 'id' ] );
}
