<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a user resets their password.
 *
 * @since 1.9.0
 */
class Reset_Password extends Abstract_Trigger {

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct() {
		add_action( $this->get_id(), array( $this, 'maybe_trigger' ), 10, 2 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'after_password_reset';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Reset Password', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'When someone resets their password', 'noptin-addons-pack' );
	}

	/**
	 * Returns an array of known smart tags.
	 *
	 * @since 1.9.0
	 * @return array
	 */
	public function get_known_smart_tags() {

		return array_merge(
			parent::get_known_smart_tags(),
			array(
				'new_pass' => array(
					'description'       => __( 'The new password', 'noptin-addons-pack' ),
					'conditional_logic' => 'string',
				),
			)
		);
	}

	/**
	 * Called when someone resets their password.
	 *
	 * @param \WP_User $user     The user.
	 * @param string   $new_pass New user password.
	 */
	public function maybe_trigger( $user, $new_pass ) {
		$this->trigger( $user, array( 'new_pass' => $new_pass ) );
	}

	/**
	 * Prepares email test data.
	 *
	 * @since 1.11.0
	 * @param Noptin_Automation_Rule $rule
	 * @return Noptin_Automation_Rules_Smart_Tags
	 * @throws Exception
	 */
	public function get_test_smart_tags( $rule ) {

		$user = wp_get_current_user();
		$args = $this->prepare_trigger_args( $user, array( 'new_pass' => wp_generate_password() ) );

		return $args['smart_tags'];
	}
}
