<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a WordPress user's role changes.
 *
 * @since 1.9.0
 */
class Set_User_Role extends Add_User_Role {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'set_user_role';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Set Role', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( "When user's role is changed", 'noptin-addons-pack' );
	}

}
