import{proxyCustomElement,HTMLElement,h}from"@stencil/core/internal/client";const prestoPlaylistUiCss=":host {\n  display: block;\n  background: transparent !important;\n}\n\n.playlist__base {\n  container-type: inline-size;\n}\n\n::slotted([provider=audio]) {\n  flex: 1;\n  box-sizing: border-box;\n  flex: 0 0 100%;\n  min-height: 300px;\n}\n\n.playlist {\n  display: flex;\n  justify-content: stretch;\n  align-items: stretch;\n  border-radius: var(--presto-playlist-border-radius, 8px);\n  overflow: hidden;\n  border-width: var(--presto-playlist-border-width, 1px);\n  border-style: solid;\n  border-color: var(--presto-playlist-border-color, #ddd);\n  background: var(--presto-playlist-background-color, #fff);\n  position: relative;\n}\n.playlist__base {\n  user-select: none;\n}\n.playlist__preview {\n  position: relative;\n  flex: 1;\n}\n.playlist__info {\n  border-radius: 8px;\n  overflow-y: scroll;\n  min-width: 300px;\n  max-width: 350px;\n  width: 30%;\n  display: flex;\n  flex-direction: column;\n  overflow: auto;\n}\n.playlist__info--inner {\n  flex: 1 1 1px;\n  overflow: auto;\n  margin: 30px;\n  margin-top: 0;\n  margin-right: 15px;\n  padding-right: 15px;\n  height: fit-content;\n  min-height: 175px;\n  /* Track */\n  /* Handle */\n  /* Handle on hover */\n}\n.playlist__info--inner .playlist__list {\n  gap: var(--presto-playlist-gap, 10px);\n  display: flex;\n  flex-direction: column;\n}\n.playlist__info--inner::-webkit-scrollbar {\n  width: 6px;\n}\n.playlist__info--inner::-webkit-scrollbar-track {\n  background: #ddd;\n  border-radius: 5px;\n}\n.playlist__info--inner::-webkit-scrollbar-thumb {\n  background: #888;\n  border-radius: 5px;\n}\n.playlist__info--inner::-webkit-scrollbar-thumb:hover {\n  background: #aaa;\n  border-radius: 5px;\n}\n.playlist__heading {\n  display: flex;\n  justify-content: space-between;\n  padding: 25px 30px 16px;\n}\n.playlist__heading-title {\n  font-size: 16px;\n  font-weight: 500;\n  color: var(--presto-playlist-text-color);\n}\n.playlist__heading-count {\n  color: var(--presto-playlist-text-color, var(--plyr-audio-control-color, #b1b1b1));\n  font-size: 12px;\n}\n\n/** Container query! */\n@container (max-width: 782px) {\n  .playlist {\n    flex-direction: column;\n  }\n  .playlist__info {\n    max-width: none;\n    min-height: none;\n    width: 100%;\n  }\n  .playlist__info--inner {\n    flex: 1;\n    height: fit-content;\n    max-height: 200px;\n    min-height: min-content;\n  }\n  .playlist__preview {\n    min-height: 200px;\n  }\n\n  ::slotted([provider=audio]) {\n    padding: 30px;\n    min-height: 200px;\n    padding-bottom: 0;\n    flex: 1;\n  }\n}\n/** Older browsers fallback */\n@media (max-width: 782px) {\n  .playlist {\n    flex-direction: column;\n  }\n  .playlist__info {\n    max-width: none;\n    min-height: none;\n    width: 100%;\n  }\n  .playlist__info--inner {\n    flex: 1;\n    height: fit-content;\n    max-height: 200px;\n    min-height: min-content;\n  }\n}",PrestoPlayListUI=proxyCustomElement(class extends HTMLElement{constructor(){super(),this.__registerHost(),this.__attachShadow()}render(){return h("div",{class:"playlist__base",part:"base"},h("div",{class:"playlist"},h("div",{class:"playlist__preview"},h("slot",{name:"preview"})),h("div",{class:"playlist__info"},h("div",{class:"playlist__heading"},h("div",{class:"playlist__heading-title"},h("slot",{name:"title"})),h("div",{class:"playlist__heading-count"},h("slot",{name:"count"}))),h("div",{class:"playlist__info--inner"},h("div",{class:"playlist__list"},h("slot",{name:"list"}))))))}static get style(){return prestoPlaylistUiCss}},[1,"presto-playlist-ui"]);function defineCustomElement(){"undefined"!=typeof customElements&&["presto-playlist-ui"].forEach((n=>{"presto-playlist-ui"===n&&(customElements.get(n)||customElements.define(n,PrestoPlayListUI))}))}defineCustomElement();export{PrestoPlayListUI as P,defineCustomElement as d};