<?php

$widget_settings = shortcode_atts( array(
	'menu' 						=> '',
	'mega_menu_full_width' 		=> 'yes',
	'sub_menu_section_tag' 		=> '',
	'item_dropdown' 			=> '',
	'responsive_icon' 			=> '',
	'responsive_icon_active' 	=> '',
	'responsive_breakpoint_switcher' => 'yes',
	'toggle_open_text' 			=> '',
	'toggle_close_text' 		=> '',
), $settings );

extract( $widget_settings );

$widget_class = 'stratum-mega-menu';

$class = stratum_menu_css_class([
	$widget_class,
	($mega_menu_full_width == 'yes' ? 'stratum-mega-menu-full-width' : ''),
	($responsive_breakpoint_switcher == 'yes' ? 'stratum-menu-is-collapsable' : ''),
]);

$close_button = '';

if ( $responsive_breakpoint_switcher == 'yes' ) {
	$close_button = '<div class="stratum-menu-toggle stratum-mega-menu-toggle is-opened">';
	$close_button .= '<button class="stratum-menu-toggle__button">';
	$close_button .= '<span class="stratum-menu-toggle__icon">';
	if ( isset( $responsive_icon_active ) ) {
		if ( 'svg' === $responsive_icon_active[ 'library' ] ) {
			$get_svg = stratum_menu_render_svg_icon( $responsive_icon_active[ 'value' ] );
			$close_button .= $get_svg;
		} else {
			$close_button .= '<i class="icon ' . esc_attr( $responsive_icon_active[ 'value' ] ) . '"></i>';
		}
	} else {
		$close_button .= '<i class="icon fa fa-times"></i>';
	}

	$close_button .= '</span>';
	if ( $toggle_close_text != '' ){
		$close_button .= '<span class="stratum-menu-toggle__text">' . esc_html( $toggle_close_text ) . '</span>';
	}
	$close_button .= '</button>';
	$close_button .= '</div>';
}

$out = "";

$args = array(
	'menu' => $menu,
	'menu_class' => '',
	'container_class' => 'stratum-menu-container',
	'items_wrap' => $close_button . '<div class="stratum-menu-wrapper"><div class="stratum-menu-items"><ul class="stratum-top-menu stratum-top-mega-menu">%3$s</ul></div></div>',
	'before'     => '',
	'after'      => '',
	'walker'     => new Stratum_Menu_Walker($widget_settings, true),
	'echo' => false,
	'fallback_cb' => false
);

$out .= '<div class="' . esc_attr( $class ) . '">';
	if( 'yes' == $responsive_breakpoint_switcher ) :
		$out .= '<div class="stratum-menu-toggle stratum-mega-menu-toggle">';
			$out .= '<button class="stratum-menu-toggle__button">';
				$out .= '<span class="stratum-menu-toggle__icon">';
					if ( isset( $responsive_icon ) ) {
						if ( 'svg' === $responsive_icon[ 'library' ] ) {
							$get_svg = stratum_menu_render_svg_icon( $responsive_icon[ 'value' ] );
							$out .= $get_svg;
						} else {
							$out .= '<i class="icon ' . esc_attr( $responsive_icon[ 'value' ] ) . '"></i>';
						}
					}
				$out .= '</span>';
				if ( $toggle_open_text != '' ) {
					$out .= '<span class="stratum-menu-toggle__text">' . esc_html( $toggle_open_text ) . '</span>';
				}
			$out .= '</button>';
		$out .= '</div>';
	endif;

	$out .= wp_nav_menu( $args );
$out .= "</div>";

echo sprintf("%s", $out);
