<?php
if (!defined('ABSPATH')) exit;

function mpcePricingTableAddonLibrary($mpceLibrary) {

    $tableObj = new MPCEObject('mpce_pta_pricing_table', __('Pricing Table', 'mpce-pta'), 'plugins/' . MPCE_PTA_PLUGIN_NAME . '/assets/images/pricing-table.png', array(
        'elements' => array(
            'type' => 'group',
            'contains' => 'mpce_pta_item',
            'items' => array(
                'label' => array(
                    'default' => __('Box', 'mpce-pta'),
                    'parameter' => 'title'
                ),
                'count' => 1
            ),
            'text' => __('Add New', 'mpce-pta'),
            'disabled' => 'false',
        ),
        'pta_columns' => array(
            'type' => 'radio-buttons',
            'label' => __('Columns count', 'mpce-pta'),
            'default' => 1,
            'list' => array(
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                6 => 6
            ),
        ),

        'pta_main_color' => array(
            'type' => 'color-picker',
            'label' => __('Primary color', 'mpce-pta'),
            'default' => '#e96656'
        ),
        'pta_bg_color' => array(
            'type' => 'color-picker',
            'label' => __('Background color', 'mpce-pta'),
            'default' => '#f9f9f9'
        ),
        'pta_alternative_color' => array(
            'type' => 'color-picker',
            'label' => __('Features color', 'mpce-pta'),
            'default' => '#fefefe'
        ),
        'pta_title_color' => array(
            'type' => 'color-picker',
            'label' => __('Title and Button color', 'mpce-pta'),
            'default' => '#ffffff'
        ),
        'pta_price_color' => array(
            'type' => 'color-picker',
            'label' => __('Price text color', 'mpce-pta'),
            'default' => '#ffffff'
        ),
        'pta_price_bg_color' => array(
            'type' => 'color-picker',
            'label' => __('Price background color', 'mpce-pta'),
            'default' => '#40454b'
        ),
        'pta_featur_color' => array(
            'type' => 'color-picker',
            'label' => __('Features text color', 'mpce-pta'),
            'default' => '#686868'
        ),

        'border' => array(
            'type' => 'radio-buttons',
            'label' => __('Border', 'mpce-pta'),
            'default' => 'solid',
            'list' => array(
                'none' => __('None', 'mpce-pta'),
                'solid' => __('Solid', 'mpce-pta')
            ),
        ),
        'border_color' => array(
            'type' => 'color-picker',
            'label' => __('Border color', 'mpce-pta'),
            'default' => '#eeeeee',
            'dependency' => array(
                'parameter' => 'border',
                'value' => 'solid'
            )
        ),
        'border_radius' => array(
            'type' => 'spinner',
            'label' => __('Border radius', 'mpce-pta'),
            'min' => 0,
            'step' => 1,
            'max' => 30,
            'default' => 3,
            'dependency' => array(
                'parameter' => 'border',
                'value' => 'solid'
            )
        ),
        'animation' => array(
            'type' => 'radio-buttons',
            'label' => __('Item animation', 'mpce-pta'),
            'default' => 'none',
            'list' => array(
                'none' => __('None', 'mpce-pta'),
                'mpce-pta-grow' => __('Zoom', 'mpce-pta'),
                'mpce-pta-translate' => __('Slide-Up', 'mpce-pta'),
            ),
        ),
        'no_wrap' => array(
            'type' => 'checkbox',
            'label' => __('Remove space between items', 'mpce-pta'),
            'default' => 'false',
            'description' => ''
        ),
        'mpce-pta-shadow' => array(
            'type' => 'checkbox',
            'label' => __('Add shadow', 'mpce-pta'),
            'default' => 'false',
            'description' => ''
        ),

        'align' => array(
            'type' => 'radio-buttons',
            'label' => __('Vertical align', 'mpce-pta'),
            'default' => 'mpce-pta-top',
            'list' => array(
                'mpce-pta-top' => __('Top', 'mpce-pta'),
                'mpce-pta-bottom' => __('Bottom', 'mpce-pta'),
            ),
        ),

    ), 93, MPCEObject::ENCLOSED, MPCEObject::RESIZE_HORIZONTAL);


    $tableItemObj = new MPCEObject('mpce_pta_item', __('Price Item', 'mpce-pta'), null, array(
        'title' => array(
            'type' => 'text',
            'label' => __('Title', 'mpce-pta'),
            'default' => __('Basic', 'mpce-pta'),
        ),
        'subtitle' => array(
            'type' => 'longtext-tinymce',
            'label' => __('Subtitle', 'mpce-pta'),
            'default' => '<p><i>Best Choice</i></p>',
            'description' => '',
            'text' => __('Edit', 'mpce-pta')
        ),
        'price_currency' => array(
            'type' => 'text',
            'label' => __('Currency', 'mpce-pta'),
            'default' => '$',
        ),
        'price_value' => array(
            'type' => 'text',
            'label' => __('Price', 'mpce-pta'),
            'default' => '49.99',
        ),
        'price_period' => array(
            'type' => 'text',
            'label' => __('Recurrence', 'mpce-pta'),
            'default' => '/ month',
        ),
        'features' => array(
            'type' => 'longtext-tinymce',
            'label' => __('Features', 'mpce-pta'),
            'default' => '<p>Feature One</p><p>Feature Two</p><p>Feature Three</p><p>Feature Four</p>',
            'description' => '',
            'text' => __('Edit', 'mpce-pta'),
            'saveInContent' => 'true'
        ),
        'button' => array(
            'type' => 'select',
            'label' => __('Button type', 'mpce-pta'),
            'default' => 'link',
            'list' => array(
                'link' => __('Simple', 'mpce-pta'),
                'script' => __('Script / HTML / Shortcode', 'mpce-pta'),
                'woo_c' => __('WooCommerce', 'mpce-pta'),
            ),
        ),
        'link_text' => array(
            'type' => 'text',
            'label' => __('Button text', 'mpce-pta'),
            'disabled' => 'false',
            'default' => 'Buy now',
            'dependency' => array(
                'parameter' => 'button',
                'value' => 'link'
            )
        ),
        'link' => array(
            'type' => 'link',
            'label' => __('Button link', 'mpce-pta'),
            'disabled' => 'false',
            'dependency' => array(
                'parameter' => 'button',
                'value' => 'link'
            )
        ),
        'script' => array(
            'type' => 'longtext64',
            'label' => __('Enter code here', 'mpce-pta'),
            'dependency' => array(
                'parameter' => 'button',
                'value' => 'script'
            )
        ),
        'woo_c' => array(
            'type' => 'text',
            'label' => __('Product ID', 'mpce-pta'),
            'dependency' => array(
                'parameter' => 'button',
                'value' => 'woo_c'
            )
        ),
        'woo_text' => array(
            'type' => 'text',
            'label' => __('Button Text', 'mpce-pta'),
            'disabled' => 'false',
            'default' => 'Buy now',
            'dependency' => array(
                'parameter' => 'button',
                'value' => 'woo_c'
            )
        ),
        'selected' => array(
            'type' => 'checkbox',
            'label' => __('Make this item special', 'mpce-pta'),
            'default' => 'false',
            'description' => ''
        ),
        'main_color' => array(
            'type' => 'color-picker',
            'label' => __('Primary color', 'mpce-pta'),
            'default' => ''
        ),
        'bg_color' => array(
            'type' => 'color-picker',
            'label' => __('Background color', 'mpce-pta'),
            'default' => ''
        ),
        'alternative_color' => array(
            'type' => 'color-picker',
            'label' => __('Features color', 'mpce-pta'),
            'default' => ''
        ),
        'title_color' => array(
            'type' => 'color-picker',
            'label' => __('Title and Button color', 'mpce-pta'),
            'default' => ''
        ),
        'price_color' => array(
            'type' => 'color-picker',
            'label' => __('Price text color', 'mpce-pta'),
            'default' => ''
        ),
        'price_bg_color' => array(
            'type' => 'color-picker',
            'label' => __('Price background Color', 'mpce-pta'),
            'default' => ''
        ),
        'featur_color' => array(
            'type' => 'color-picker',
            'label' => __('Features text color', 'mpce-pta'),
            'default' => ''
        ),

    ), null, MPCEObject::ENCLOSED, MPCEObject::RESIZE_NONE, false);

    $tableObj->addStyle(array(
        'mp_style_classes' => array(
            'basic' => array(
                'class' =>'mpce-pta-wrapper',
                'label' => __('Pricing Table Base', 'mpce-pta')
            )
        )
    ));

    $mpceLibrary->addObject($tableObj, MPCEShortcode::PREFIX . 'other');
    $mpceLibrary->addObject($tableItemObj, MPCEShortcode::PREFIX . 'other');
}
add_action('mp_library', 'mpcePricingTableAddonLibrary', 11, 1);