<?php
/*
Plugin Name: MotoPress Pricing Table Addon
Plugin URI: https://motopress.com/products/pricing-table-addon/
Description: Create pricing tables for your website the easy way.
Version: 1.3.2
Author: MotoPress
Author URI: https://motopress.com/
Text Domain: mpce-pta
License: GPL2 or later
*/



global $wp_version;
if (version_compare($wp_version, '3.9', '<') && isset($network_plugin)) {
    define('MPCE_PTA_PLUGIN_FILE', $network_plugin);
} else {
    define('MPCE_PTA_PLUGIN_FILE', __FILE__);
}
define('MPCE_PTA_PLUGIN_DIR', trailingslashit(plugin_dir_path(MPCE_PTA_PLUGIN_FILE)));

if( !function_exists('isContentEditor')){
    function isContentEditor() {
        return method_exists('MPCEShortcode', 'isContentEditor') && MPCEShortcode::isContentEditor();
    }
}

require_once MPCE_PTA_PLUGIN_DIR . 'inc/license.php';
require_once MPCE_PTA_PLUGIN_DIR . 'inc/settings.php';
require_once MPCE_PTA_PLUGIN_DIR . 'inc/mpLibrary.php';
require_once MPCE_PTA_PLUGIN_DIR . 'inc/shortcodes.php';
require_once MPCE_PTA_PLUGIN_DIR . 'inc/simpleShortcodes.php';
require_once MPCE_PTA_PLUGIN_DIR . 'inc/settingsPage.php';
require_once MPCE_PTA_PLUGIN_DIR . 'inc/EDD_MPCE_PTA_Plugin_Updater.php';

function mpcePTALoadTextdomain() {
    load_plugin_textdomain('mpce-pta', FALSE, MPCE_PTA_PLUGIN_NAME . '/lang/');
}
add_action('plugins_loaded', 'mpcePTALoadTextdomain');

function mpcePTAAdminInit() {
	new EDD_MPCE_PTA_Plugin_Updater(MPCE_PTA_EDD_STORE_URL, __FILE__, array(
		'version' => MPCE_PTA_VERSION, // current version number
		'license' => get_option('edd_mpce_pta_license_key'), // license key (used get_option above to retrieve from DB)
		'item_id' => MPCE_PTA_EDD_ITEM_ID, // id of this plugin
		'author'  => MPCE_PTA_AUTHOR // author of this plugin
    ));
}
add_action('admin_init', 'mpcePTAAdminInit');

function mpcePTAEnqueueScripts() {
    wp_register_style('mpce-pta-style', MPCE_PTA_PLUGIN_DIR_URL . 'assets/css/style.min.css', array(), MPCE_PTA_VERSION);

    wp_register_script('mpce-pta-script', MPCE_PTA_PLUGIN_DIR_URL . 'assets/js/engine.min.js', array('jquery'), MPCE_PTA_VERSION, true);
    wp_register_script('mpce-pta-admin-script', MPCE_PTA_PLUGIN_DIR_URL . 'assets/js/engine-admin.min.js', array('jquery'), MPCE_PTA_VERSION, true);

    if( isContentEditor() ){
		wp_enqueue_style('mpce-pta-style');
		wp_enqueue_script('mpce-pta-script');
        wp_enqueue_script('mpce-pta-admin-script');
    }

}
add_action('wp_enqueue_scripts', 'mpcePTAEnqueueScripts');


function mpcePTALicenseInit($hookSuffix) {
    global $ptaLicense;
    add_filter('admin_mpce_license_tabs', 'mpcePTALicenseTab');
    add_action('admin_mpce_license_save-' . MPCE_PTA_PLUGIN_SHORT_NAME, array(&$ptaLicense, 'save'));
}
add_action('admin_mpce_license_init', 'mpcePTALicenseInit');

// Plugin Activation
function motopressPTAInstall($network_wide) {
    $autoLicenseKey = apply_filters('pta_auto_license_key', false);
    if ($autoLicenseKey) {
        PTALicense::setAndActivateLicenseKey($autoLicenseKey);
    }
}
register_activation_hook(__FILE__, 'motopressPTAInstall');
