<?php

namespace Noptin\Addons_Pack\Users\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Deletes a user.
 *
 * @since 1.10.0
 */
class Delete_User extends Abstract_Action {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'delete_user';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Delete User', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'Deletes the user', 'noptin-addons-pack' );
	}

	/**
	 * Updates the user's role.
	 *
	 * @since 1.10.0
	 * @param mixed $subject The subject.
	 * @param \Noptin_Automation_Rule $rule The automation rule used to trigger the action.
	 * @param array $args Extra arguments passed to the action.
	 * @return void
	 */
	public function run( $subject, $rule, $args ) {

		// Fetch the user.
		$user = $this->get_user( $subject, $rule, $args );

		// Delete the user.
		wp_delete_user( $user->ID );

	}
}
