<?php
$dataset = woo_ce_export_dataset( $export->type );

if( !empty( $dataset ) ) {

	// Load up the fatal error notice if we 500, timeout or encounter a fatal PHP error
	add_action( 'shutdown', 'woo_ce_fatal_error' );

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'cron.php - before loading PHPSpreadsheet: ' . ( time() - $export->start_time ) ) );

	// Check that PHPSpreadsheet is where we think it is
	if( file_exists( WOO_CD_PATH . 'vendor/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Spreadsheet.php' ) ) {
		// Check if PHPSpreadsheet has already been loaded
		if( !class_exists( '\PhpOffice\PhpSpreadsheet\Spreadsheet' ) ) {
			require_once WOO_CD_PATH  . 'vendor/autoload.php';
		} else {
			$message = __( 'The PHPSpreadsheet library was already loaded by another WordPress Plugin, if there\'s issues with your export file you know where to look.', 'woocommerce-exporter' );
			woo_ce_error_log( sprintf( '%s: Warning: %s', $export->filename, $message ) );
		}

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'cron.php - after loading PHPSpreadsheet: ' . ( time() - $export->start_time ) ) );

		// Cache control
		do_action( 'woo_ce_export_phpexcel_caching_methods' );

		// Final check incase something is blocking PHPSpreadsheet
		if( !class_exists( '\PhpOffice\PhpSpreadsheet\Spreadsheet' ) ) {
			$message = sprintf( __( 'We couldn\'t load the PHPSpreadsheet library <code>%s</code> within <code>%s</code> even after trying workarounds, this file should be present. <a href="%s" target="_blank">Need help?</a>', 'woocommerce-exporter' ), 'Spreadsheet.php', WOO_CD_PATH . 'vendor/phpoffice/phpspreadsheet/src/PhpSpreadsheet...', $troubleshooting_url );
			woo_ce_error_log( sprintf( '%s: Error: %s', $export->filename, $message ) );
			return;
		}

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'cron.php - before building PHPSpreadsheet export contents: ' . ( time() - $export->start_time ) ) );

		$excel = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
		$excel->setActiveSheetIndex( 0 );
		$excel->getActiveSheet()->setTitle( apply_filters( 'woo_ce_custom_worksheet_name', ucfirst( $export->type ) ) );

		// Check if we are forcing use of an alternate temp directory
		if( apply_filters( 'woo_ce_phpexcel_force_temp_dir', false ) )
			\PhpOffice\PhpSpreadsheet\Shared\File::setUseUploadTempDirectory( true );

		$alternate_layout = apply_filters( 'woo_ce_phpexcel_force_alternate_layout', false );

		$row = 1;

		// Allow Plugin/Theme authors to add in rows at the start of the export
		$excel = apply_filters( 'woo_ce_phpexcel_sheet_header', $excel, $row, $export->type, $export->export_format, $alternate_layout );

		// Allow Plugin/Theme authors to adjust the export starting row
		$row = apply_filters( 'woo_ce_phpexcel_sheet_start_row', $row, $export->type, $export->export_format, $alternate_layout );

		// Allow Plugin/Theme authors to adjust how many header rows they want
		$custom_layout = apply_filters( 'woo_ce_phpexcel_force_custom_layout', false );
		$header_rows = apply_filters( 'woo_ce_phpexcel_custom_header_rows', '0' );


		// Skip headers if Heading Formatting is turned off
		if( $export->header_formatting ) {
			$col = 1;
			$counter = 0;
			foreach( $export->columns as $column ) {
				$excel->getActiveSheet()->setCellValueByColumnAndRow( $col, $row, woo_ce_wp_specialchars_decode( $column ) );
				$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->getStyle()->getFont()->setBold( true );
				$excel->getActiveSheet()->getColumnDimensionByColumn( $col )->setAutoSize( true );

				// Allow Plugin/Theme authors to apply header column changes
				$excel = apply_filters( 'woo_ce_phpexcel_sheet_header_column', $excel, $col, $row, $export->type, $export->export_format, $alternate_layout );

				if ( $counter > ( $header_rows - 1 ) && $custom_layout ) {
					$alternate_layout = false;
				}

				if( $alternate_layout )
					$row++;
				else
					$col++;

				$counter++;
			}

			if( $alternate_layout ) {
				$col = 3;
			} else {
				$row++;
			}

		}
		if( $alternate_layout )
			$row = 1;
		else
			$col = 1;

		// Start iterating through the export data
		$count = 0;
		foreach( $dataset as $data ) {

			if( $custom_layout ) {
				$alternate_layout = apply_filters( 'woo_ce_phpexcel_force_alternate_layout', false );
				$row = 1;
				$col = 2;
			} else {
				if( $alternate_layout ) {
					$row = 1;
				} else {
					$col = 1;
				}
			}

			$counter = 0;
			foreach( array_keys( $export->fields ) as $field ) {

				// $excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->getStyle()->getFont()->setBold( false );

				// Embed Image paths as thumbnails exclusively within the XLSX export type
				if( $export->export_format == 'xlsx' && in_array( $field, woo_ce_get_image_embed_allowed_fields() ) ) {
					if( !empty( $data->$field ) ) {

						// Check that the Image path has been filled
						if( $data->$field == false ) {
							$col++;
							continue;
						}

						// Check if PHPSpreadsheet_Worksheet_Drawing is present
						if( class_exists( '\PhpOffice\PhpSpreadsheet\Worksheet\Drawing' ) ) {

							// Check for the Category separator character
							$image_paths = explode( $export->category_separator, $data->$field );
							if( !empty( $image_paths ) ) {
								$i = 0;
								foreach( $image_paths as $image_path ) {

									// Check the image path exists
									if( file_exists( $image_path ) == false )
										continue;

									$objDrawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
									$objDrawing->setName( '' );
									$objDrawing->setDescription( '' );
									$objDrawing->setPath( $image_path, true );
									$objDrawing->setCoordinates( \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex( $col ) . $row );
									$shop_thumbnail = apply_filters( 'woo_ce_override_embed_shop_thumbnail', false, $export->type );
									if( $shop_thumbnail == false ) {
										// Override for the image embed thumbnail size; use registered WordPress image size names
										$thumbnail_size = apply_filters( 'woo_ce_override_embed_thumbnail_size', 'shop_thumbnail', $export->type );
										$shop_thumbnail = ( function_exists( 'wc_get_image_size' ) ? wc_get_image_size( $thumbnail_size ) : array( 'height' => 100 ) );
									}
									$objDrawing->setHeight( ( isset( $shop_thumbnail['height'] ) ? absint( $shop_thumbnail['height'] ) : 100 ) );
									$objDrawing->setWorksheet( $excel->getActiveSheet() );
									$excel->getActiveSheet()->getRowDimension( $row )->setRowHeight( ( isset( $shop_thumbnail['height'] ) ? $shop_thumbnail['height'] : 100 ) );
									// Adjust the offset for multiple Images
									if( !empty( $i ) )
										$objDrawing->setOffsetX( ( isset( $shop_thumbnail['height'] ) ? $shop_thumbnail['height'] : 100 ) * $i );
									unset( $objDrawing );
									$i++;

								}
							}

						} else {
							$message = __( 'We couldn\'t load the PHPSpreadsheet_Worksheet_Drawing class attached to PHPSpreadsheet, the PHPSpreadsheet_Worksheet_Drawing class is required for embedding images within XLSX exports.', 'woocommerce-exporter' );
							woo_ce_error_log( sprintf( '%s: Warning: %s', $export->filename, $message ) );
						}

						$col++;
						continue;

					}
				}

				$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->getStyle()->getFont()->setBold( false );

				if( $export->encoding == 'UTF-8' ) {
					if( woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ) ) ) {
						// Treat this cell as a string
						$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? woo_ce_wp_specialchars_decode( $data->$field ) : '' ), \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING );
					} else {
						// Detect the cell type or default to PHPSpreadsheet
						$type = woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ), 'type' );
						if( !is_null( $type ) )
							$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? woo_ce_wp_specialchars_decode( $data->$field, null, $type ) : '' ), $type );
						else
							$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValue( ( isset( $data->$field ) ? woo_ce_wp_specialchars_decode( $data->$field ) : '' ) );
					}
				} else {
					// PHPSpreadsheet only deals with UTF-8 regardless of encoding type
					if( woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ) ) ) {
						// Treat this cell as a string
						$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? utf8_encode( woo_ce_wp_specialchars_decode( $data->$field ) ) : '' ), \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING );
					} else {
						// Detect the cell type or default to PHPSpreadsheet
						$type = woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ), 'type' );
						if( !is_null( $type ) )
							$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? utf8_encode( woo_ce_wp_specialchars_decode( $data->$field, null, $type ) ) : '' ), $type );
						else
							$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValue( ( isset( $data->$field ) ? utf8_encode( woo_ce_wp_specialchars_decode( $data->$field ) ) : '' ) );
						unset( $type );
					}
				}

				if ( $counter === ( $header_rows - 1 ) && $custom_layout ) {
					$alternate_layout = false;
					$col = -1;
					$row = ( $header_rows + 2 ) + $count;
				}

				if( $alternate_layout )
					$row++;
				else
					$col++;

				$counter++;

			}

			// Allow Plugin/Theme authors to add in blank rows
			$excel = apply_filters( 'woo_ce_phpexcel_sheet', $excel, $row, $export->type, $export->export_format );

			// Allow Plugin/Theme authors to control the row counter
			$row = apply_filters( 'woo_ce_phpexcel_row', $row, $export->type, $export->export_format );

			if( $alternate_layout )
				$col++;
			else
				$row++;

			$count++;

		}

		// Allow Plugin/Theme authors to add in rows at the end of the export
		$excel = apply_filters( 'woo_ce_phpexcel_sheet_footer', $excel, $row, $export->type, $export->export_format );

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'cron.php - after building PHPSpreadsheet export contents: ' . ( time() - $export->start_time ) ) );

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'cron.php - before building PHPSpreadsheet export file: ' . ( time() - $export->start_time ) ) );

		if( in_array( $export->export_format, array( 'xlsx', 'xls' ) ) ) {
			// Use this switch to toggle the legacy PCLZip Class instead of ZipArchive Class within PHPSpreadsheet
			if( apply_filters( 'woo_ce_export_phpexcel_ziparchive_legacy', false, $export->export_format ) )
				\PhpOffice\PhpSpreadsheet\Settings::setZipClass( \PhpOffice\PhpSpreadsheet\Settings::PCLZIP );
		}

		// Send the export to the factory
		$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter( $excel, $php_excel_format );

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'cron.php - after building PHPSpreadsheet export file: ' . ( time() - $export->start_time ) ) );

		switch( $export->export_format ) {

			case 'csv':
				if( $export->bom )
					$objWriter->setUseBOM( true );
				// Check if we're using a non-standard delimiter
				if( $export->delimiter != ',' )
					$objWriter->setDelimiter( $export->delimiter );
				break;

			case 'tsv':
				if( $export->bom )
					$objWriter->setUseBOM( true );
				$objWriter->setDelimiter( "\t" );
				break;

			case 'xlsx':
				$has_formulas = apply_filters( 'woo_ce_phpexcel_export_formulas', $export->excel_formulas );
				$objWriter->setPreCalculateFormulas( $has_formulas );
				break;

		}
		// Print directly to browser
		if( in_array( $gui, array( 'raw' ) ) ) {

			$objWriter->save( 'php://output' );

		} else {
			// Save file to PHP tmp then pass to PHPSpreadsheet
			$temp_filename = tempnam( apply_filters( 'woo_ce_sys_get_temp_dir', sys_get_temp_dir() ), 'tmp' );
			// Check if we were given a temporary filename
			if( $temp_filename == false ) {
				$message = sprintf( __( 'We could not create a temporary export file in %s, ensure that WordPress can read and write files here and try again.', 'woocommerce-exporter' ), apply_filters( 'woo_ce_sys_get_temp_dir', sys_get_temp_dir() ) );
				$export->error = $message;
				woo_ce_error_log( sprintf( '%s: Error: %s', $export->filename, $export->error ) );
			} else {
				$objWriter->save( $temp_filename );
				$bits = file_get_contents( $temp_filename );
			}
		}

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'end export generation: ' . ( time() - $export->start_time ) ) );

		// Clean up PHPSpreadsheet
		$excel->disconnectWorksheets();
		unset( $objWriter, $excel );

	} else {
		$message = __( 'We couldn\'t load the PHPSpreadsheet library, this file should be present.', 'woocommerce-exporter' );
		$export->error = $message;
		woo_ce_error_log( sprintf( '%s: Error: %s', $export->filename, $export->error ) );
	}

	// Remove our fatal error notice to play nice with other Plugins
	remove_action( 'shutdown', 'woo_ce_fatal_error' );

}