<?php
if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - before woo_ce_export_dataset(): ' . ( time() - $export->start_time ) ) );
$dataset = woo_ce_export_dataset( $export->type );
if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - after woo_ce_export_dataset(): ' . ( time() - $export->start_time ) ) );

// Check if we have data to export
if( empty( $dataset ) ) {
	$message = __( 'No export entries were found, please try again with different export filters.', 'woocommerce-exporter' );
	if( $export->offset )
		$message .= ' ' . __( 'Try clearing the value set for the Volume Offset under Export Options.', 'woocommerce-exporter' );
	woo_cd_admin_notice( $message, 'error' );
	// Reset the count Transient for this export type in case it is out of date
	delete_transient( WOO_CD_PREFIX . '_' . $export->type . '_count' );
	return;
}

// Load up the fatal error notice if we 500, timeout or encounter a fatal PHP error
add_action( 'shutdown', 'woo_ce_fatal_error' );

if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - before loading PHPExcel: ' . ( time() - $export->start_time ) ) );

// Check that PHPExcel is where we think it is
if( file_exists( WOO_CD_PATH . 'classes/PHPExcel.php' ) ) {
	// Check if PHPExcel has already been loaded
	if( !class_exists( 'PHPExcel' ) ) {
		include_once( WOO_CD_PATH . 'classes/PHPExcel.php' );
	} else {
		// Let's try to locate the filepath of the already registered PHPExcel Class
		if( class_exists( 'ReflectionClass' ) ) {
			$reflector = new ReflectionClass( 'PHPExcel' );
			$message = sprintf( __( 'The required PHPExcel library was already loaded by another WordPress Plugin located at %s. If there\'s issues with your export file contact the Plugin author of the mentioned Plugin.', 'woocommerce-exporter' ), $reflector->getFileName() );
			$message .= sprintf( '<a href="%s" target="_blank">%s</a>', $troubleshooting_url, __( 'Need help?', 'woocommerce-exporter' ) );
			woo_cd_admin_notice( $message, 'error' );
			unset( $reflector );
		// Nope, we couldn't detect the filepath so display default notice
		} else {
			$message = __( 'The required PHPExcel library was already loaded by another WordPress Plugin, unfortunately however we cannot automatically detect which Plugin. If there\'s issues with your export file you now know where to start looking.', 'woocommerce-exporter' );
			$message .= sprintf( '<a href="%s" target="_blank">%s</a>', $troubleshooting_url, __( 'Need help?', 'woocommerce-exporter' ) );
			woo_cd_admin_notice( $message, 'error' );
		}
	}
} else {
	$message = sprintf( __( 'We couldn\'t load the PHPExcel library <code>%s</code> within <code>%s</code>, this file should be present. <a href="%s" target="_blank">Need help?</a>', 'woocommerce-exporter' ), 'PHPExcel.php', WOO_CD_PATH . 'classes/...', $troubleshooting_url );
	woo_cd_admin_notice( $message, 'error' );
	return;
}

if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - after loading PHPExcel: ' . ( time() - $export->start_time ) ) );

// Cache control
do_action( 'woo_ce_export_phpexcel_caching_methods' );

// Final check incase something is blocking PHPExcel
if( !class_exists( 'PHPExcel' ) ) {
	$message = sprintf( __( 'We couldn\'t load the PHPExcel library <code>%s</code> within <code>%s</code> even after trying workarounds, this file should be present. <a href="%s" target="_blank">Need help?</a>', 'woocommerce-exporter' ), 'PHPExcel.php', WOO_CD_PATH . 'classes/...', $troubleshooting_url );
	woo_cd_admin_notice( $message, 'error' );
	return;
}

if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - before building PHPExcel export contents: ' . ( time() - $export->start_time ) ) );

$excel = new PHPExcel();
$excel->setActiveSheetIndex( 0 );
$excel->getActiveSheet()->setTitle( apply_filters( 'woo_ce_custom_worksheet_name', ucfirst( $export->type ) ) );

// Check if we are forcing use of an alternate temp directory
if( apply_filters( 'woo_ce_phpexcel_force_temp_dir', false ) )
	PHPExcel_Shared_File::setUseUploadTempDirectory( true );

$alternate_layout = apply_filters( 'woo_ce_phpexcel_force_alternate_layout', false );

$row = 1;

// Allow Plugin/Theme authors to add in rows at the start of the export
$excel = apply_filters( 'woo_ce_phpexcel_sheet_header', $excel, $row, $export->type, $export->export_format, $alternate_layout );

// Allow Plugin/Theme authors to adjust the export starting row
$row = apply_filters( 'woo_ce_phpexcel_sheet_start_row', $row, $export->type, $export->export_format, $alternate_layout );

// Allow Plugin/Theme authors to adjust how many header rows they want
$custom_layout = apply_filters( 'woo_ce_phpexcel_force_custom_layout', false );
$header_rows = apply_filters( 'woo_ce_phpexcel_custom_header_rows', '0' );

// Skip headers if Heading Formatting is turned off
if( $export->header_formatting ) {
	$col = 0;
	$counter = 0;
	foreach( $export->columns as $column ) {
		$excel->getActiveSheet()->setCellValueByColumnAndRow( $col, $row, woo_ce_wp_specialchars_decode( $column ) );
		$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->getStyle()->getFont()->setBold( true );
		$excel->getActiveSheet()->getColumnDimensionByColumn( $col )->setAutoSize( true );

		// Allow Plugin/Theme authors to apply header column changes
		$excel = apply_filters( 'woo_ce_phpexcel_sheet_header_column', $excel, $col, $row, $export->type, $export->export_format, $alternate_layout );

		if ( $counter > ( $header_rows - 1 ) && $custom_layout ) {
			$alternate_layout = false;
		}

		if( $alternate_layout )
			$row++;
		else
			$col++;

		$counter++;
	}
	
	if( $alternate_layout ) {
		$col = 2;
	} else {
		$row++;
	}

}
if( $alternate_layout )
	$row = 1;
else
	$col = 0;

// Start iterating through the export data
$count = 0;
foreach( $dataset as $data ) {

	if( $custom_layout ) {
		$alternate_layout = apply_filters( 'woo_ce_phpexcel_force_alternate_layout', false );
		$row = 1;
		$col = 1;
	} else {
		if( $alternate_layout ) {
			$row = 1;
		} else {
			$col = 0;
		}
	}

	$counter = 0;
	foreach( array_keys( $export->fields ) as $field ) {

		// $excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->getStyle()->getFont()->setBold( false );

		// Embed Image paths as thumbnails exclusively within the XLSX export type
		if( $export->export_format == 'xlsx' && in_array( $field, woo_ce_get_image_embed_allowed_fields() ) ) {
			if( !empty( $data->$field ) ) {

				// Check that the Image path has been filled
				if( $data->$field == false ) {
					$col++;
					continue;
				}

				// Check if PHPExcel_Worksheet_Drawing is present
				if( class_exists( 'PHPExcel_Worksheet_Drawing' ) ) {

					// Check for the Category separator character
					$image_paths = explode( $export->category_separator, $data->$field );
					if( !empty( $image_paths ) ) {
						$i = 0;
						foreach( $image_paths as $image_path ) {

							// Check the image path exists
							if( file_exists( $image_path ) == false )
								continue;

							$objDrawing = new PHPExcel_Worksheet_Drawing();
							$objDrawing->setName( '' );
							$objDrawing->setDescription( '' );
							$objDrawing->setPath( $image_path );
							$objDrawing->setCoordinates( PHPExcel_Cell::stringFromColumnIndex( $col ) . $row );
							$shop_thumbnail = apply_filters( 'woo_ce_override_embed_shop_thumbnail', false, $export->type );
							if( $shop_thumbnail == false ) {
								// Override for the image embed thumbnail size; use registered WordPress image size names
								$thumbnail_size = apply_filters( 'woo_ce_override_embed_thumbnail_size', 'shop_thumbnail', $export->type );
								$shop_thumbnail = ( function_exists( 'wc_get_image_size' ) ? wc_get_image_size( $thumbnail_size ) : array( 'height' => 100 ) );
							}
							$objDrawing->setHeight( ( isset( $shop_thumbnail['height'] ) ? absint( $shop_thumbnail['height'] ) : 100 ) );
							$objDrawing->setWorksheet( $excel->getActiveSheet() );
							$excel->getActiveSheet()->getRowDimension( $row )->setRowHeight( ( isset( $shop_thumbnail['height'] ) ? $shop_thumbnail['height'] : 100 ) );
							// Adjust the offset for multiple Images
							if( !empty( $i ) )
								$objDrawing->setOffsetX( ( isset( $shop_thumbnail['height'] ) ? $shop_thumbnail['height'] : 100 ) * $i );
							unset( $objDrawing );
							$i++;

						}
					}

				} else {
					$message = __( 'We couldn\'t load the PHPExcel_Worksheet_Drawing class attached to PHPExcel, the PHPExcel_Worksheet_Drawing class is required for embedding images within XLSX exports.', 'woocommerce-exporter' );
					$message .= sprintf( '<a href="%s" target="_blank">%s</a>', $troubleshooting_url, __( 'Need help?', 'woocommerce-exporter' ) );
					woo_cd_admin_notice( $message, 'error' );
					return;
				}

				$col++;
				continue;

			}
		}

		$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->getStyle()->getFont()->setBold( false );

		if( $export->encoding == 'UTF-8' ) {
			if( woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ) ) ) {
				// Treat this cell as a string
				$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? woo_ce_wp_specialchars_decode( $data->$field ) : '' ), PHPExcel_Cell_DataType::TYPE_STRING );
			} else {
				// Detect the cell type or default to PHPExcel
				$type = woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ), 'type' );
				if( !is_null( $type ) )
					$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? woo_ce_wp_specialchars_decode( $data->$field, null, $type ) : '' ), $type );
				else
					$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValue( ( isset( $data->$field ) ? woo_ce_wp_specialchars_decode( $data->$field ) : '' ) );
			}
		} else {
			// PHPExcel only deals with UTF-8 regardless of encoding type
			if( woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ) ) ) {
				// Treat this cell as a string
				$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? utf8_encode( woo_ce_wp_specialchars_decode( $data->$field ) ) : '' ), PHPExcel_Cell_DataType::TYPE_STRING );
			} else {
				// Detect the cell type or default to PHPExcel
				$type = woo_ce_detect_value_string( ( isset( $data->$field ) ? $data->$field : null ), 'type' );
				if( !is_null( $type ) )
					$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValueExplicit( ( isset( $data->$field ) ? utf8_encode( woo_ce_wp_specialchars_decode( $data->$field, null, $type ) ) : '' ), $type );
				else
					$excel->getActiveSheet()->getCellByColumnAndRow( $col, $row )->setValue( ( isset( $data->$field ) ? utf8_encode( woo_ce_wp_specialchars_decode( $data->$field ) ) : '' ) );
				unset( $type );
			}
		}

		if ( $counter === ( $header_rows - 1 ) && $custom_layout ) {
			$alternate_layout = false;
			$col = -1;
			$row = ( $header_rows + 2 ) + $count;
		}

		if( $alternate_layout )
			$row++;
		else
			$col++;

		$counter++;

	}

	// Allow Plugin/Theme authors to add in blank rows
	$excel = apply_filters( 'woo_ce_phpexcel_sheet', $excel, $row, $export->type, $export->export_format );

	// Allow Plugin/Theme authors to control the row counter
	$row = apply_filters( 'woo_ce_phpexcel_row', $row, $export->type, $export->export_format );

	if( $alternate_layout )
		$col++;
	else
		$row++;

	$count++;

}

// Allow Plugin/Theme authors to add in rows at the end of the export
$excel = apply_filters( 'woo_ce_phpexcel_sheet_footer', $excel, $row, $export->type, $export->export_format );

if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - after building PHPExcel export contents: ' . ( time() - $export->start_time ) ) );

// Override the export format to CSV if debug mode is enabled
if( WOO_CD_DEBUG )
	$export->export_format = 'csv';

if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - before building PHPExcel export file: ' . ( time() - $export->start_time ) ) );

// Load our custom Writer for the CSV and TSV file types
if( in_array( $export->export_format, apply_filters( 'woo_ce_phpexcel_csv_writer_export_formats', array( 'csv', 'tsv' ) ) ) ) {
	include_once( WOO_CD_PATH . 'includes/export-csv.php' );
	// We need to load this after the PHPExcel Class has been created
	woo_cd_load_phpexcel_sed_csv_writer();
} else if( in_array( $export->export_format, array( 'xlsx', 'xls' ) ) ) {
	// Use this switch to toggle the legacy PCLZip Class instead of ZipArchive Class within PHPExcel
	if( apply_filters( 'woo_ce_export_phpexcel_ziparchive_legacy', false, $export->export_format ) )
		PHPExcel_Settings::setZipClass( PHPExcel_Settings::PCLZIP );
}

// Set the file extension and MIME type
switch( $export->export_format ) {

	// Defaults to CSV
	default:
	case 'csv':

		// Allow Plugin/Theme authors to add support for additional export formats

		// Only load SED_CSV PHPExcel Writer if it has been loaded
		if( class_exists( 'PHPExcel_Writer_SED_CSV' ) )
			$php_excel_format = apply_filters( 'woo_ce_phpexcel_export_format_writer', 'SED_CSV', $export->export_format );
		else
			$php_excel_format = apply_filters( 'woo_ce_phpexcel_export_format_writer', 'CSV', $export->export_format );
		$file_extension = apply_filters( 'woo_ce_phpexcel_export_format_file_extension', 'csv', $export->export_format );
		$post_mime_type = apply_filters( 'woo_ce_phpexcel_export_format_mime_type', 'text/csv', $export->export_format );
		break;

	case 'tsv':
		$php_excel_format = 'SED_CSV';
		$file_extension = 'tsv';
		$post_mime_type = 'text/tab-separated-values';
		break;

	case 'xls':
		$php_excel_format = 'Excel5';
		$file_extension = 'xls';
		$post_mime_type = 'application/vnd.ms-excel';
		break;

	case 'xlsx':
		$php_excel_format = 'Excel2007';
		$file_extension = 'xlsx';
		$post_mime_type = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
		break;

}

// Tack on the file extension
$export->filename = $export->filename . '.' . $file_extension;

// Send the export to the factory
$objWriter = PHPExcel_IOFactory::createWriter( $excel, $php_excel_format );

if( WOO_CD_LOGGING )
	woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - after building PHPExcel export file: ' . ( time() - $export->start_time ) ) );

// Only write headers if we're not in debug mode
if( !WOO_CD_DEBUG ) {

	// Print to browser

	// Check if we are printing file headers
	if( apply_filters( 'woo_ce_export_print_to_browser', true ) )
		woo_ce_generate_file_headers( $post_mime_type );

	switch( $export->export_format ) {

		case 'csv':
			if( $export->bom )
				$objWriter->setUseBOM( true );
			// Check if we're using a non-standard delimiter
			if( $export->delimiter != ',' )
				$objWriter->setDelimiter( $export->delimiter );
			break;

		case 'tsv':
			if( $export->bom )
				$objWriter->setUseBOM( true );
			$objWriter->setDelimiter( "\t" );
			break;

		case 'xlsx':
			$has_formulas = apply_filters( 'woo_ce_phpexcel_export_formulas', $export->excel_formulas );
			$objWriter->setPreCalculateFormulas( $has_formulas );
			break;

		default:
			// Allow Plugin/Theme authors to add support for additional export formats
			$objWriter = apply_filters( 'woo_ce_phpexcel_export_format_writer_options', $objWriter, $export->export_format );
			break;

	}
	// Print directly to browser, do not save to the WordPress Media
	if( woo_ce_get_option( 'delete_file', 1 ) ) {

		// The end memory usage and time is collected at the very last opportunity prior to the file header being rendered to the screen
		delete_option( WOO_CD_PREFIX . '_exported' );
		$objWriter->save( 'php://output' );

	} else {

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - before saving export file to Archives: ' . ( time() - $export->start_time ) ) );

		// Save to file and insert to WordPress Media
		$temp_filename = tempnam( apply_filters( 'woo_ce_sys_get_temp_dir', sys_get_temp_dir() ), 'tmp' );
		// Check if we were given a temporary filename
		if( $temp_filename == false ) {

			$message = sprintf( __( 'We could not create a temporary export file in <code>%s</code>, ensure that WordPress can read and write files to this directory and try again.', 'woocommerce-exporter' ), apply_filters( 'woo_ce_sys_get_temp_dir', sys_get_temp_dir() ) );
			woo_ce_error_log( sprintf( '%s: Error: %s', $export->filename, $message ) );
			woo_cd_admin_notice( $message, 'error' );
			$url = add_query_arg( array( 'failed' => true, 'message' => urlencode( $message ) ) );
			wp_redirect( $url );
			exit();

		} else {
			$objWriter->save( $temp_filename );
			$bits = file_get_contents( $temp_filename );
		}
		unlink( $temp_filename );

		$post_ID = woo_ce_save_file_attachment( $export->filename, $post_mime_type );
		$upload = wp_upload_bits( $export->filename, null, $bits );
		// Check if the upload succeeded otherwise delete Post and return error notice
		if( ( $post_ID == false ) || $upload['error'] ) {
			wp_delete_attachment( $post_ID, true );
			if( isset( $upload['error'] ) ) {
				woo_ce_error_log( sprintf( '%s: Error: %s', $export->filename, $upload['error'] ) );
				$url = add_query_arg( array( 'failed' => true, 'message' => urlencode( $upload['error'] ) ) );
				wp_redirect( $url );
			} else {
				$url = add_query_arg( array( 'failed' => true ) );
				wp_redirect( $url );
			}
			return;
		}

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - after saving export file to Archives: ' . ( time() - $export->start_time ) ) );

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - before updating archive file details: ' . ( time() - $export->start_time ) ) );

		// Load the WordPress Media API resources
		if( file_exists( ABSPATH . 'wp-admin/includes/image.php' ) ) {
			$attach_data = wp_generate_attachment_metadata( $post_ID, $upload['file'] );
			wp_update_attachment_metadata( $post_ID, $attach_data );
			update_attached_file( $post_ID, $upload['file'] );
			if( !empty( $post_ID ) ) {
				woo_ce_save_file_guid( $post_ID, $export->type, $upload['url'] );
				woo_ce_save_file_details( $post_ID );
			}
		} else {
			$message = __( 'Could not load image.php within /wp-admin/includes/image.php', 'woocommerce-exporter' );
			woo_ce_error_log( sprintf( '%s: Error: %s', $export->filename, $message ) );
		}

		// The end memory usage and time is collected at the very last opportunity prior to the file header being rendered to the screen
		woo_ce_update_file_detail( $post_ID, '_woo_idle_memory_end', woo_ce_current_memory_usage() );
		woo_ce_update_file_detail( $post_ID, '_woo_end_time', time() );

		if( WOO_CD_LOGGING )
			woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - after updating archive file details: ' . ( time() - $export->start_time ) ) );

		delete_option( WOO_CD_PREFIX . '_exported' );

		// Clear opening notice flag
		if( !woo_ce_get_option( 'dismiss_overview_prompt', 0 ) )
			woo_ce_update_option( 'dismiss_overview_prompt', 1 );

		// Check if we are returning the export file to the browser
		if( apply_filters( 'woo_ce_export_print_to_browser', true ) ) {
			$objWriter->save( 'php://output' );
		} else {
			$message = sprintf( __( 'The quick export completed successfully, <a href="%s">open the Archives tab</a> to download your export file.', 'woocommerce-exporter' ), esc_url( add_query_arg( array( 'tab' => 'archive' ) ) ) );
			woo_cd_admin_notice( $message );
			$url = add_query_arg( array( 'success' => true ) );
			wp_redirect( $url );
		}

	}

	if( WOO_CD_LOGGING )
		woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - end export generation: ' . ( time() - $export->start_time ) ) );

	// Clean up PHPExcel
	$excel->disconnectWorksheets();
	unset( $objWriter, $excel );
	exit();

} else {

	// Save to temporary file then dump into export log screen
	if( $export->bom )
		$objWriter->setUseBOM( true );
	$temp_filename = tempnam( apply_filters( 'woo_ce_sys_get_temp_dir', sys_get_temp_dir() ), 'tmp' );
	// Check if we were given a temporary filename
	if( $temp_filename == false ) {
		$message = sprintf( __( 'We could not create a temporary export file in <code>%s</code>, ensure that WordPress can read and write files to this directory and try again.', 'woocommerce-exporter' ), apply_filters( 'woo_ce_sys_get_temp_dir', sys_get_temp_dir() ) );
		woo_cd_admin_notice( $message, 'error' );
	} else {
		$objWriter->save( $temp_filename );
		$bits = file_get_contents( $temp_filename );
	}
	unlink( $temp_filename );

	if( WOO_CD_LOGGING )
		woo_ce_error_log( sprintf( 'Debug: %s', 'exporter-deluxe.php - end export generation: ' . ( time() - $export->start_time ) ) );

	// Clean up PHPExcel
	$excel->disconnectWorksheets();
	unset( $objWriter, $excel );

	// Save the export contents to the WordPress Transient, base64 encode it to get around Transient storage formatting issues 
	$response = set_transient( WOO_CD_PREFIX . '_debug_log', base64_encode( $bits ), woo_ce_get_option( 'timeout', ( MINUTE_IN_SECONDS * 10 ) ) );
	if( $response !== true ) {
		$message = __( 'The export contents were too large to store in a single WordPress transient, use the Volume offset / Limit volume options to reduce the size of your export and try again.', 'woocommerce-exporter' );
		$message .= sprintf( ' (<a href="%s" target="_blank">%s</a>)', $troubleshooting_url, __( 'Need help?', 'woocommerce-exporter' ) );
		woo_cd_admin_notice( $message, 'error' );
	}

}

// Remove our fatal error notice to play nice with other Plugins
remove_action( 'shutdown', 'woo_ce_fatal_error' );