<?php
if (!defined('ABSPATH')) exit;

function mpcePTASettingsTab($tabs) {
	$tabs[MPCE_PTA_PLUGIN_SHORT_NAME] = array(
		'label' => __('Price Boxes', 'mpce-pta'),
		'priority' => 10,
		'callback' => 'mpcePTASettingsTabContent'
	);
	return $tabs;
}

function mpcePTASettingsTabContent() {
	if (isset($_GET['settings-updated']) && $_GET['settings-updated']) {
        add_settings_error(
            'mpcePTASettings',
            esc_attr('settings_updated'),
            __('Settings saved.', 'mpce-pta'),
            'updated'
        );
    }
	settings_errors('mpcePTASettings', false);
	echo '<form actoin="options.php" method="POST">';
//    settings_fields('mpcePTAOptionsFields');
	do_settings_sections('mpce_pta_options');
	echo '<p class="submit"><input type="submit" name="submit" id="submit" class="button-primary" value="' . __('Save', 'mpce-pta') . '" /></p>';
	echo '</form>';
}

function mpcePTASettingsSave() {
	if (!empty($_POST)) {
		$settings = get_option('mpce-pta-settings', array());
		if (isset($_POST['server_api_key'])) {
			$settings['server_api_key'] = $_POST['server_api_key'];
		}
		if (isset($_POST['browser_api_key'])) {
			$settings['browser_api_key'] = $_POST['browser_api_key'];
		}
		update_option('mpce-pta-settings', $settings);
		wp_redirect(add_query_arg(array('page' => $_GET['page'], 'plugin' => $_GET['plugin'], 'settings-updated' => 'true'), admin_url('admin.php')));
	}
}

function mpcePTALicenseTab($tabs) {
    global $ptaLicense;
	$tabs[MPCE_PTA_PLUGIN_SHORT_NAME] = array(
		'label' => __('Pricing Table  Addon', 'mpce-pta'),
		'priority' => 10,
        'callback' => array(&$ptaLicense, 'renderPage')
	);
	return $tabs;
}