<?php

/**
 * Noptin for WooCommerce
 *
 * Adds more WooCommerce features to Noptin.
 *
 *
 * Plugin Name:     Noptin for WooCommerce
 * Plugin URI:      https://noptin.com/woocommerce
 * Description:     Adds more WooCommerce features to Noptin.
 * Author:          picocodes
 * Author URI:      https://github.com/picocodes
 * Version:         1.0.6
 * Text Domain:     noptin-woocommerce
 * License:         GPL3+
 * License URI:     http://www.gnu.org/licenses/gpl-3.0.txt
 * Domain Path:     /languages
 *
 * @since           1.0.0
 * @author          Picocodes
 * @author          Kaz
 * @license         GNU General Public License, version 3
 * @copyright       Picocodes
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

define( 'NOPTIN_WOOCOMMERCE_VERSION', '1.0.6' );
define( 'NOPTIN_WOOCOMMERCE_FILE', __FILE__ );

/**
 * Load after Noptin Loads.
 *
 * @param Noptin_Integrations $integrations Integrations instance.
 */
function noptin_woocommerce_load( $integrations ) {

    // Check that we're using at least Noptin 1.8.0
    if ( version_compare( noptin()->version, '1.8.0', '<' ) || ! class_exists( 'WooCommerce' ) ) {
        return;
    }

    // Include the autoloader so we can dynamically include the rest of the classes.
    require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';

    // Load the connection.
    $integrations->integrations['advanced_woocommerce'] = new Noptin\WooCommerce\Plugin();

}
add_action( 'noptin_integrations_load', 'noptin_woocommerce_load' );

/**
 * Load translations after all plugins have loaded.
 */
function noptin_woocommerce_load_textdomain() {
    load_plugin_textdomain( 'noptin-woocommerce', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'noptin_woocommerce_load_textdomain' );

/**
 * Displays a notice if Noptin 1.8.0 or above is not installed.
 */
function noptin_woocommerce_admin_notice() {

    if ( ! current_user_can( 'manage_options' ) || ! function_exists( 'noptin' ) || ! version_compare( noptin()->version, '1.8.0', '<' ) ) {
        return;
    }

    // Print a notice with a thickbox link to the plugin installation page.
    ?>
        <div class="notice notice-error">
            <p>
                <?php
                    printf(
                        /* translators: %s: Noptin plugin name */
                        esc_html__( 'The %1$s plugin requires Noptin version 1.8.0 or above to work. Please %2$sinstall or update%3$s Noptin.', 'noptin-woocommerce' ),
                        '<strong>' . esc_html__( 'WooCommerce Integration', 'noptin-woocommerce' ) . '</strong>',
                        '<a href="' . esc_url( admin_url( 'plugin-install.php?tab=plugin-information&plugin=newsletter-optin-box&TB_iframe=true&width=772&height=600' ) ) . '" class="thickbox" aria-label="Noptin" data-title="Noptin">',
                        '</a>'
					);
                ?>
            </p>
        </div>
    <?php

    add_thickbox();
}
add_action( 'admin_notices', 'noptin_woocommerce_admin_notice' );

/**
 * Register this as a premium addon.
 *
 * @param array $noptin_addons
 * @return array
 */
function noptin_woocommerce_register_premium_addon( $noptin_addons ) {

	$noptin_addons['noptin-woocommerce'] = 'Noptin for WooCommerce';
	return $noptin_addons;
}
add_filter( 'noptin_premium_addons', 'noptin_woocommerce_register_premium_addon' );
