<?php

namespace Stratum_Menu;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

final class Stratum_Menu {
	/**
	 * @var Stratum_Menu
	 */
	private static $instance = null;

	/**
	 * @var Settings
	 */
	private $settings;

	/**
	 * @var Post_Type_Manager
	 */
	private $post_type_manager;

	/**
	 * @var Scripts_Manager
	 */
	private $scripts_manager;

	/**
	 * @var Widgets_Manager
	 */
	private $widgets_manager;

	/**
	 * @var VersionControl
	 */
	private $version_control;

	private function __construct() {
		if ( did_action( 'elementor/loaded' ) ) {
			$this->post_type_manager	 = new \Stratum_Menu\Managers\Post_Type_Manager();
		}
		$this->scripts_manager		 = new \Stratum_Menu\Managers\Scripts_Manager();
		$this->widgets_manager		 = new \Stratum_Menu\Managers\Widgets_Manager();
		$this->version_control		 = new Version_Control();
	}

    /**
     * @return Post_Type_Manager
     */
    public function get_post_type_manager() {
        return $this->post_type_manager;
    }

    /**
     * @return Scripts_Manager
     */
    public function get_scripts_manager() {
        return $this->scripts_manager;
    }

    /**
     * @return Widgets_Manager
     */
    public function get_widgets_manager() {
        return $this->widgets_manager;
	}

    /**
     * @return Stratum_Menu
     */
    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
		}

        return self::$instance;
    }
}
