<?php
/**
 *
 * Plugin main file
 *
 * Plugin Name:          Other
 * Description:          This plugin provides integration of the Other service with WooCommerce.
 * Version:              3.1.1
 */

/**
 * Check if WooCommerce is active
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    
    
    add_action('admin_menu', 'other_api_add_admin_menu');
    function other_api_add_admin_menu()
    {
        add_options_page('Other', 'Other', 'manage_options', 'other-settings-api-page', 'other_api_options_page');
    }
    
    add_action('admin_init', 'other_api_settings_init');
    function other_api_settings_init()
    {
        register_setting('otherPlugin', 'other_api_settings');
        add_settings_section('other_api_otherPlugin_section_1', __('General Settings', 'wordpress'), null, 'otherPlugin');
        
        add_settings_field('other_send_subscription_api_url', __('URL', 'wordpress'), 'other_send_subscription_api_url_render', 'otherPlugin', 'other_api_otherPlugin_section_1');
        
        add_settings_section('other_api_otherPlugin_section_2', __('#1', 'wordpress'), null, 'otherPlugin');
        
        add_settings_field('other_send_subscription_api_tv_usa_login', __('Login', 'wordpress'), 'other_send_subscription_api_tv_usa_login_render', 'otherPlugin', 'other_api_otherPlugin_section_2');
        
        add_settings_field('other_send_subscription_api_tv_usa_token', __('Token', 'wordpress'), 'other_send_subscription_api_tv_usa_token_render', 'otherPlugin', 'other_api_otherPlugin_section_2');

        add_settings_field('other_send_subscription_api_tv_usa_provider_id', __('ID', 'wordpress'), 'other_send_subscription_api_tv_usa_provider_id_render', 'otherPlugin', 'other_api_otherPlugin_section_2');
    }
    
    function other_send_subscription_api_url_render()
    {
        $options = get_option('other_api_settings');
?>
		<input type='password' style='min-width: 50%;' name='other_api_settings[other_send_subscription_api_url]' value='<?php
        echo $options['other_send_subscription_api_url'];
?>'>
		<?php
    }
    
    function other_send_subscription_api_tv_usa_login_render()
    {
        $options = get_option('other_api_settings');
?>
		<input type='password' style='min-width: 50%;' name='other_api_settings[other_send_subscription_api_tv_usa_login]' value='<?php
        echo $options['other_send_subscription_api_tv_usa_login'];
?>'>
		<?php
    }
    
    function other_send_subscription_api_tv_usa_token_render()
    {
        $options = get_option('other_api_settings');
?>
		<input type='password' style='min-width: 50%;' name='other_api_settings[other_send_subscription_api_tv_usa_token]' value='<?php
        echo $options['other_send_subscription_api_tv_usa_token'];
?>'>
		<?php
    }

        function other_send_subscription_api_tv_usa_provider_id_render()
    {
        $options = get_option('other_api_settings');
?>
        <input type='password' style='min-width: 50%;' name='other_api_settings[other_send_subscription_api_tv_usa_provider_id]' value='<?php
        echo $options['other_send_subscription_api_tv_usa_provider_id'];
?>'>
        <?php
    }
    
    function other_api_options_page()
    {
?>
		<form action='options.php' method='post'>

			<style type="text/css">
				h2{
					border: 0.1px solid lightgray;
					padding: 10px;
					margin-right: 20px;
				}
				h3{
					margin-bottom: 2em;
				}
				.form-table{
					margin-left: 10px;
				}
			</style>

			<h3>Settings</h3>
			<?php
        settings_fields('otherPlugin');
        do_settings_sections('otherPlugin');
        submit_button();
?>

		</form>
		<?php
    }
    
    /**
 * Add a custom product tab.
 */
    function other_custom_product_tabs( $tabs) {
        $tabs['other'] = array(
            'label'     => __( 'Other', 'woocommerce' ),
            'target'    => 'other_options',
            'class'     => array( 'show_if_simple', 'show_if_variable'  ),
        );
        return $tabs;
    }
    add_filter( 'woocommerce_product_data_tabs', 'other_custom_product_tabs' );

/**
 * Contents of the gift card options product tab.
 */
function other_options_product_tab_content() {
    global $post;
    
    // Note the 'id' attribute needs to match the 'target' parameter set above
    ?><div id='other_options' class='panel woocommerce_options_panel'><?php
        ?><div class='options_group'><?php
            woocommerce_wp_text_input( array(
                'id'                => '_subscription_id',
                'label'             => __( 'ID', 'woocommerce' ),
                'desc_tip'          => 'true',
                'description'       => __( 'Enter the subscription Id for Other Product.', 'woocommerce' ),
                'type'              => 'text',
            ) );
            woocommerce_wp_text_input( array(
                'id'                => '_device_count',
                'label'             => __( 'Count', 'woocommerce' ),
                'desc_tip'          => 'true',
                'description'       => __( 'Enter the device count for Other Product.', 'woocommerce' ),
                'type'              => 'text',
            ) );
        ?></div>

    </div><?php
}
add_filter( 'woocommerce_product_data_panels', 'other_options_product_tab_content' ); // WC 2.6 and up
/**
 * Save the custom fields.
 */
function save_other_options_fields( $post_id ) {
    
    if ( isset( $_POST['_subscription_id'] ) ) :
        update_post_meta( $post_id, '_subscription_id', $_POST['_subscription_id'] );
    endif;

    if ( isset( $_POST['_device_count'] ) ) :
        update_post_meta( $post_id, '_device_count', $_POST['_device_count'] );
    endif;
    
}
add_action( 'woocommerce_process_product_meta_simple', 'save_other_options_fields'  );
add_action( 'woocommerce_process_product_meta_variable', 'save_other_options_fields'  );


    add_action('woocommerce_order_status_processing', 'other_send_api_request_on_processing');
    function other_send_api_request_on_processing($order_id)
    {
        write_log("______________________________________________________________________________________________________________________________________");
        write_log("SENDING SUBSCRIPTION FOR ORDER NUMBER $order_id");

        $options                                    = get_option('other_api_settings', array());
        $other_send_subscription_api_tv_usa_login = $options['other_send_subscription_api_tv_usa_login'];
        $other_send_subscription_api_tv_usa_token = $options['other_send_subscription_api_tv_usa_token'];
        $other_send_subscription_api_url          = $options['other_send_subscription_api_url'];

        try {
            
            $id                 = $order_id;
            $subscriberCreated  = false;
            $order          = wc_get_order($order_id);
            $order_data     = $order->get_data();
            $customer_id    = $order->get_user_id();

            foreach ($order->get_items() as $item_key => $item) {
                
                $product         = $item->get_product();
                $product_details = $item->get_data();
                $deviceCount                                = get_post_meta( $product->get_ID(), '_device_count', true );
                $subscriptionId                             = get_post_meta( $product->get_ID(), '_subscription_id', true );
                
                if ($subscriptionId && $subscriptionId != '' && $deviceCount && $deviceCount != '') {
                    
                write_log("Other order product subscriptionId-->$subscriptionId, deviceCount-->$deviceCount");

                $firstname                  = empty($order_data['billing']['first_name']) ? 'missing' : $order_data['billing']['first_name'];
                $lastname                   = empty($order_data['billing']['last_name']) ? 'missing' : $order_data['billing']['last_name'];
                $telephone                  = empty(preg_replace("/[^0-9]/", '', $order_data['billing']['phone'])) ? '00000000' : $order_data['billing']['phone'];
                $payment_address_1          = empty($order_data['billing']['address_1']) ? 'missing' : $order_data['billing']['address_1'];
                $payment_postcode           = empty($order_data['billing']['postcode']) ? '00000' : $order_data['billing']['postcode'];
                $payment_city               = empty($order_data['billing']['city']) ? 'missing' : $order_data['billing']['city'];
                $payment_country            = $order_data['billing']['country'];
                $payment_zone               = $order_data['billing']['state'];
                $email                      = $order_data['billing']['email'];
                
                $firstname         = preg_replace("/[^A-Za-z0-9 ]/", '', $firstname);
                $lastname          = preg_replace("/[^A-Za-z0-9 ]/", '', $lastname);
                $payment_address_1 = preg_replace("/[^A-Za-z0-9 ]/", '', $payment_address_1);
                $payment_postcode  = preg_replace("/[^A-Za-z0-9 ]/", '', $payment_postcode);
                $payment_city      = preg_replace("/[^A-Za-z0-9 ]/", '', $payment_city);
                $payment_country   = preg_replace("/[^A-Za-z0-9 ]/", '', $payment_country);
                $payment_zone      = preg_replace("/[^A-Za-z0-9 ]/", '', $payment_zone);

                $accountNumber = other_get_userdata($customer_id, 'other_subscription_id');
                $userName = other_get_userdata($customer_id, 'other_subscription_username');
                $password = other_get_userdata($customer_id, 'other_subscription_password');
  
                if($accountNumber != ''){
                write_log("Other alredy have a accountNumber-->$accountNumber");
                $subscriberCreated = true;
                }
                
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
                curl_setopt($curl, CURLOPT_POST, true);
                
                if ((!$subscriberCreated) && $subscriptionId != '') {
                    
                    write_log("Other order product call for subscriptionId-->$subscriptionId");
                                     
                    $json_data_array = array(
                        'auth' => array(
                            'token' => $other_send_subscription_api_tv_usa_token,
                            'login' => $other_send_subscription_api_tv_usa_login
                        ),
                        'phone' => $telephone,
                        'zipCode' => $payment_postcode,
                        'firstName' => $firstname,
                        'lastName' => $lastname,
                        'email' => $email,
                        'address' => $payment_address_1,
                        'city' => $payment_city,
                        'country' => 'US',
                        'state' => $payment_zone,
                        'timeZone' => 'US/Eastern'
                    );
                    
                    $content = json_encode($json_data_array);
                    write_log('Other create subscriber request-->' . $content);
                    
                    $url = $other_send_subscription_api_url . '/subscribers/create/';
                    
                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
                    $json_response = curl_exec($curl);
                    write_log('Other create subscriber response-->' . $json_response);
                    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                    
                    if ($status != 201 && $status != 200) {
                        
                        write_log("Other create subscriber error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
                        
                    } else { // Other create subscriber server call is success
                        
                        write_log("Other hit url: $url /* RESPOSE $json_response");
                        $response = json_decode($json_response, true);
                        
                        $statusCode    = $response['status']['code'];
                        $statusMessage = $response['status']['message'];
                        
                        if ($statusCode == 0) { // Other create subscriber api call is success
                            
                            $accountNumber = $response['result']['accountNumber'];
                            
                            if (isset($response['result']['userName']) === true && empty($response['result']['userName']) === false) {
                                write_log('Other response userName-->' . $response['result']['userName']);
                                $userName = $response['result']['userName'];
                            }
                            if (isset($response['result']['password']) === true && empty($response['result']['password']) === false) {
                                write_log('Other response password-->' . $response['result']['password']);
                                $password = $response['result']['password'];
                            }
                            
                            $subscriberCreated = true;

                            update_user_meta( $customer_id, 'other_subscription_id', $accountNumber );
                            update_user_meta( $customer_id, 'other_subscription_username', $userName );
                            update_user_meta( $customer_id, 'other_subscription_password', $password );

                            write_log("Other create subscriber accountNumber-->$accountNumber, userName-->$userName, password-->$password");
                            
                        } else {
                            write_log("Other create subscriber faild with status code $statusCode and message $statusMessage");
                        }
                        
                    }
                    
                }
                
                if ($subscriberCreated && $subscriptionId != '') {
                    
                    write_log("Other make payment call for subscriptionId-->$subscriptionId");
                    
                    $json_data_array = array(
                        'auth' => array(
                            'token' => $other_send_subscription_api_tv_usa_token,
                            'login' => $other_send_subscription_api_tv_usa_login,
                            'accountNumber' => $accountNumber,
                            'lastName' => $lastname
                        ),
                        'deviceCount' => $deviceCount,
                        'subscriptionId' => $subscriptionId,
						'approvalRequired'=>'false',
						'paymentSystemType'=>'EXTERNAL_PAYMENTS',
						'externalPaymentSystemType'=>'PAYPAL_EXPRESS',
						'transactionId'=>'$'
                    );
                    
                    $content = json_encode($json_data_array);
                    $url     = $other_send_subscription_api_url . '/payments/do';
                    
                    write_log('Other make payment request-->' . $content);
                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
                    $json_response = curl_exec($curl);
                    write_log('Other make payment response-->' . $json_response);
                    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                    
                    if ($status != 201 && $status != 200) {
                        
                        write_log("Other make payment error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
                        
                    } else { // Other make payment server call is success
                        
                        $response      = json_decode($json_response, true);
                        $statusCode    = $response['status']['code'];
                        $statusMessage = $response['status']['message'];
                        
                        if ($statusCode == 0) { // Other make payment api call is success
                            
                            // Get subscribers activation codes
                            
                            $json_data_array = array(
                                'auth' => array(
                                    'token' => $other_send_subscription_api_tv_usa_token,
                                    'login' => $other_send_subscription_api_tv_usa_login,
                                    'accountNumber' => $accountNumber,
                                    'lastName' => $lastname
                                )
                            );
                            
                            $content = json_encode($json_data_array);
                            $url     = $other_send_subscription_api_url . '/activationcodes/get';
                            
                            write_log('Other Get subscribers activation codes request-->' . $content);
                            curl_setopt($curl, CURLOPT_URL, $url);
                            curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
                            $json_response = curl_exec($curl);
                            write_log('Other Get subscribers activation codes response-->' . $json_response);
                            $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                            
                            if ($status != 201 && $status != 200) {
                                
                                write_log("Other get subscribers activation codes error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
                                
                            } else { // Other get subscribers activation codes server call is success
                                
                                $response      = json_decode($json_response, true);
                                $statusCode    = $response['status']['code'];
                                $statusMessage = $response['status']['message'];
                                
                                if ($statusCode == 0) { // Other get subscribers activation codes api call is success
                                    
                                    $item        = 0;
                                    $activations = "";
                                    
                                    foreach ($response['result'] as $result) {
                                        
                                        $activationCodeId = $result['activationCodeId'];
                                        $linkCode         = $result['linkCode'];
                                        $expirationTime   = date_format(date_create($result['expirationTime']), 'g:ia \o\n l jS F Y');
                                        $item++;
                                        $activations = $activations . "<b>($item). Device Link Code:</b> $linkCode<br/><b>Expiration:</b> $expirationTime<br/>";
                                        
                                    }
                                    
                                    write_log("Other  get subscribers activation codes activations-->$activations, and updating order status to completed");

                                    // Update the DB with the new processed status
                                    $order->update_status('completed');


                                    // Get subscriber's payments
                                    
                                    $json_data_array = array(
                                        'auth' => array(
                                            'token' => $other_send_subscription_api_tv_usa_token,
                                            'login' => $other_send_subscription_api_tv_usa_login,
                                            'accountNumber' => $accountNumber,
                                            'lastName' => $lastname
                                        )
                                    );
                                    
                                    $content = json_encode($json_data_array);
                                    $url     = $other_send_subscription_api_url . '/payments/get';
                                    
                                    write_log('Other Get subscribers payments request-->' . $content);
                                    curl_setopt($curl, CURLOPT_URL, $url);
                                    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
                                    $json_response = curl_exec($curl);
                                    write_log('Other get subscribers payments response-->' . $json_response);
                                    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                                    
                                    if ($status != 201 && $status != 200) {
                                        
                                        write_log("Other get subscribers payments error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
                                        
                                    } else { // Other get subscribers payments server call is success
                                        
                                        $response      = json_decode($json_response, true);
                                        $statusCode    = $response['status']['code'];
                                        $statusMessage = $response['status']['message'];
                                        
                                        if ($statusCode == 0) { // Other get subscribers payments api call is success
                                            
                                            $item     = 0;
                                            $payments = "";
                                            
                                            foreach ($response['result'] as $result) {
                                                
                                                $activeFrom  = date_format(date_create($result['activeFrom']), 'jS F Y');
                                                $activeUntil = date_format(date_create($result['activeUntil']), 'jS F Y');
                                                $processDate = date_format(date_create($result['processDate']), 'jS F Y');
                                                
                                                $item++;
                                                $payments = $payments . "<b>($item).</b> Payment made on $processDate is active until $activeUntil<br/>";
                                                
                                            }
                                            
                                            write_log("Other get subscribers payments-->$payments");

                                        } else {
                                            write_log("Other get subscribers activation codes faild with status code $statusCode and message $statusMessage");
                                        }
                                        
                                    }
                                    
                                    
                                } else {
                                    write_log("Other get subscribers activation codes faild with status code $statusCode and message $statusMessage");
                                }
                                
                            }
                            
                        } else {
                            write_log("Other make payment faild with status code $statusCode and message $statusMessage");
                        }
                        
                    }
                    
                }
                
                curl_close($curl);
                
			}else{
                write_log("Other order product don't have subscriptionId ($subscriptionId) or deviceCount ($deviceCount)");
			}
				
            }
            
        }
        catch (Exception $e) {
            $errorMessage = $e->getMessage();
            write_log("Other send subscription exception: $errorMessage");
        }
        
        write_log("______________________________________________________________________________________________________________________________________");
        //SEND SUBSCRIPTION FOR WOO CART PLUGIN END
        
    }


add_action( 'woocommerce_email_after_order_table', 'other_email_show_subscription', 20, 4 );
 
function other_email_show_subscription( $order, $sent_to_admin, $plain_text, $email ) {
  other_show_subscription($order->get_ID(), true);
}

add_action( 'woocommerce_order_details_after_customer_details', 'other_show_subscription', 1 ); 
function other_show_subscription( $order_id, $is_email = false ) {

    $order = wc_get_order( $order_id );
    $order_data = $order->get_data();
    $customer_id    = $order->get_user_id();
    $options                                    = get_option('other_api_settings', array());
    $other_send_subscription_api_tv_usa_login = $options['other_send_subscription_api_tv_usa_login'];
    $other_send_subscription_api_tv_usa_token = $options['other_send_subscription_api_tv_usa_token'];
    $other_send_subscription_api_url          = $options['other_send_subscription_api_url'];
    $provider_id = $options['other_send_subscription_api_tv_usa_provider_id'];
    $accountNumber = other_get_userdata($customer_id, 'other_subscription_id');
    $password = other_get_userdata($customer_id, 'other_subscription_password');
    $lastname = $order_data['billing']['last_name'];

        try
        {
        
        if($accountNumber && $accountNumber != ''){

            write_log("Other have a accountNumber-->$accountNumber");
            
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
            curl_setopt($curl, CURLOPT_POST, true);
            
            // Get subscribers info         
            $json_data_array = array(
                    'auth'=> array('token'=> $other_send_subscription_api_tv_usa_token , 'login'=> $other_send_subscription_api_tv_usa_login , 'accountNumber' => $accountNumber, 'lastName' => $lastname)
            );
            
            $content = json_encode($json_data_array);
            $url = $other_send_subscription_api_url . '/subscribers/get';
            
            write_log('Other Get subscribers info request-->' . $content);
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
            
            $json_response = curl_exec($curl);
            write_log('Other get subscribers info response-->' . $json_response);
            $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            
            if ( $status != 201 && $status != 200) {
                
                write_log("Other get subscribers info error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
                
            }else{ // Other get subscribers infoserver call is success
                
                $response = json_decode($json_response, true);
                $statusCode = $response['status']['code'];
                $statusMessage= $response['status']['message'];
                
                if($statusCode == 0){ // Other get subscribers info api call is success

                    $data['subscriber_info'] = $response["result"];
                    $data['subscriber_info']['password'] = $password;
                    $data['subscriber_info']['provider_id'] = $provider_id;
                    
                    $subscriber_info = $data['subscriber_info'];
                    
                    $replace['account_number'] = $subscriber_info['accountNumber'];
                    $replace['user_name'] = $subscriber_info['userName'];
                    $replace['password'] = $subscriber_info['password'];
                    $replace['pin_code'] = $subscriber_info['pinCode'];
                    $replace['device_count'] = $subscriber_info['deviceCount'];
                    $replace['subscription_expires'] = date_format(date_create($subscriber_info['expirationTime']), 'jS F Y');
                    
                    $item = 0;
                    
                    foreach($subscriber_info['activationCodes'] as $result) {
                        
                        $activationCodeId = $result['activationCodeId'];
                        $linkCode = $result['linkCode'];
                        $expirationTime= date_format(date_create($result['expirationTime']), 'g:ia \ol jS F Y');
                        
                        $item++;
                        
                        $replace["device_link_code_$item"] = $linkCode;
                        $replace["device_link_code_expires_$item"] = $expirationTime;
                        
                    }                   

                }else{
                    write_log("Other get subscribers activation codes faild with status code $statusCode and message $statusMessage");
                }
                
            }
            
        }
        
        }
        catch (Exception $e)
        {
            $errorMessage = $e->getMessage();
            write_log("Other Details on Mail replace array exception: $errorMessage");
        }

 if(isset($subscriber_info)){

?>
                    <?php  if(!$is_email){ ?>
                    <script type="text/javascript">
                             function renewActivationCode(activationCodeId){

                                        var data = {
                                            'action': 'other_renew_ativation_code',
                                            'activationCodeId': activationCodeId ,
                                            'accountNumber': '<?php echo $accountNumber; ?>',
                                            'lastname': '<?php echo $lastname; ?>',
                                        };
                                        jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', data, function(result) {
                                            if(result.status.code == 0){
                                                window.location.reload();
                                            }else{
                                                alert('Activation code renew failure');
                                            }
                                        })
                                        .fail(function(response) {
                                            alert('Error: ' + response.responseText);
                                        });
                                        ;
                                        
                             }
                     </script>
                    <?php } ?>
                    <h2>TV Subscriber Information</h2>

                    <table class="table table-bordered table-hover td" style="width:100%;">
                         <tbody>
                           <tr>
                             <td class="text-left td" colspan="4"  style="vertical-align: top;">
                                 <div style="float: left;"><h4>Your Subscription Details</h4></div>
                                 <div style="float: right;"><h5>Subscription expires on <?php echo date_format(date_create($subscriber_info['expirationTime']), 'jS F Y'); ?></h5></div>
                             </td>
                           </tr>
                           <tr>
                             <td class="text-left td" style="width: 25%;" ><b>Account Number:</b> <?php echo $subscriber_info['accountNumber']; ?></td>
                             <td class="text-left td" style="width: 25%;"><b>User Name:</b> <?php echo $subscriber_info['userName']; ?></td>
                             <td class="text-left td" style="width: 25%;"><b>Password:</b> <?php echo $subscriber_info['password']; ?></td>
                             <td class="text-left td" style="width: 25%;"><b>Blocked Channel PIN:</b> <?php echo $subscriber_info['pinCode']; ?></td>
                           </tr>

                           <tr>
                             <td class="text-left td" colspan="3"  style="vertical-align: top;">
                             <div style="float: left;"><h4>Activation Codes</h4></div>
                             <div style="float: right;">
                                     <h5>
                                             Unused Device Link Codes expire after a period of time, To get a new code, simply click RENEW next to the expired code.
                                                         Link Code expiration is not your subscription expiration date.
                                                 </h5>
                                         </div>
                             </td>
                             <td class="text-left td" style=""><?php if(!empty($subscriber_info['provider_id'])) { ?> <h5><b>Provider ID:</b> <?php echo $subscriber_info['provider_id']; ?></h5> <?php } ?><h5><b>Device Count:</b> <?php echo $subscriber_info['deviceCount']; ?></h5></td>
                           </tr>
                          <?php

                          $item = 0;

                          foreach($subscriber_info['activationCodes'] as $result) {

                                 $activationCodeId = $result['activationCodeId'];
                                 $linkCode = $result['linkCode'];
                                 $expirationTime= date_format(date_create($result['expirationTime']), 'g:ia \o\n l jS F Y');

                                 $item++;

                                 ?>
                           <tr>
                             <td class="text-left td" style=""><b>Device Link Code:</b> <?php echo $linkCode; ?></td>
                             <td class="text-left td" colspan="<?php echo($is_email ? '3' : '2') ?>" style=""><b>Unused code expires:</b> <?php echo $expirationTime; ?></td>
                            <?php  if(!$is_email){ ?>
                             <td class="text-left td" style=""><button id="renew<?php echo $item; ?>" name="renew" value="<?php echo $activationCodeId; ?>" onclick="renewActivationCode('<?php echo $activationCodeId; ?>')" style="width: 100%;height: 100%">Renew</button></td>
                             <?php } ?>
                           </tr>

                          <?php } ?>

                         </tbody>
                       </table>

<?php    
        
}

}


/**
 * Get additional account fields.
 * @return array
 */
function other_get_account_fields() {
    return apply_filters( 'other_account_fields', array(
        'other_subscription_id' => array(
            'type'                 => 'text',
            'class'                => array('regular-text'),
            'label'                => __( 'TV Subscription Id', 'other' ),
            'placeholder'          => __( 'TV Subscription Id', 'other' ),
            'required'             => false,
            'hide_in_account'      => true,
            'hide_in_admin'        => false,
            'hide_in_checkout'     => true,
            'hide_in_registration' => true,
        ),
            'other_subscription_username' => array(
            'type'                 => 'text',
            'class'                => array('regular-text'),
            'label'                => __( 'TV Subscription User Name', 'other' ),
            'placeholder'          => __( 'TV Subscription User Name', 'other' ),
            'required'             => false,
            'hide_in_account'      => true,
            'hide_in_admin'        => false,
            'hide_in_checkout'     => true,
            'hide_in_registration' => true,
        ),
            'other_subscription_password' => array(
            'type'                 => 'text',
            'class'                => array('regular-text'),
            'label'                => __( 'TV Subscription Password', 'other' ),
            'placeholder'          => __( 'TV Subscription Password', 'other' ),
            'required'             => false,
            'hide_in_account'      => true,
            'hide_in_admin'        => false,
            'hide_in_checkout'     => true,
            'hide_in_registration' => true,
        ),
    ) );
}

/**
 * Add fields to admin area.
 */
function other_print_user_admin_fields() {
    $fields = other_get_account_fields();
    ?>
    <h2><?php _e( 'Additional Information', 'other' ); ?></h2>
    <table class="form-table" id="other-additional-information">
        <tbody>
        <?php foreach ( $fields as $key => $field_args ) { 

            $user_id = other_get_edit_user_id();
            $value   = other_get_userdata( $user_id, $key );
            write_log("Other other_print_user_admin_fields $user_id $value");
            ?>
            <tr>
                <th>
                    <label for="<?php echo $key; ?>"><?php echo $field_args['label']; ?></label>
                </th>
                <td>
                    <?php $field_args['label'] = false; ?>
                    <?php woocommerce_form_field( $key, $field_args, $value ); ?>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
    <?php
}

add_action( 'show_user_profile', 'other_print_user_admin_fields', 30 ); // admin: edit profile
add_action( 'edit_user_profile', 'other_print_user_admin_fields', 30 ); // admin: edit other users
	
/**
 * Get currently editing user ID (frontend account/edit profile/edit other user).
 * @return int
 */
function other_get_edit_user_id() {
    return isset( $_GET['user_id'] ) ? (int) $_GET['user_id'] : get_current_user_id();
}

/**
 * Save registration fields.
 * @param int $customer_id
 */
function other_save_account_fields( $customer_id ) {
    $fields = other_get_account_fields();
    $sanitized_data = array();
    foreach ( $fields as $key => $field_args ) {
        if ( ! other_is_field_visible( $field_args ) ) {
            continue;
        }
 
        $sanitize = isset( $field_args['sanitize'] ) ? $field_args['sanitize'] : 'wc_clean';
        $value    = isset( $_POST[ $key ] ) ? call_user_func( $sanitize, $_POST[ $key ] ) : '';
 
        if ( other_is_userdata( $key ) ) {
            $sanitized_data[ $key ] = $value;
            continue;
        }        
 
        write_log("Other other_save_account_fields $customer_id $key $value");
        update_user_meta( $customer_id, $key, $value );
    }
 
    if ( ! empty( $sanitized_data ) ) {
        $sanitized_data['ID'] = $customer_id;
        wp_update_user( $sanitized_data );
    }
}
 
add_action( 'woocommerce_created_customer', 'other_save_account_fields' ); // register/checkout
add_action( 'personal_options_update', 'other_save_account_fields' ); // edit own account admin
add_action( 'edit_user_profile_update', 'other_save_account_fields' ); // edit other account admin
add_action( 'woocommerce_save_account_details', 'other_save_account_fields' ); // edit WC account

/**
 * Is field visible.
 *
 * @param $field_args
 *
 * @return bool
 */
function other_is_field_visible( $field_args ) {
    $visible = true;
    $action = filter_input( INPUT_POST, 'action' );

    if ( is_admin() && ! empty( $field_args['hide_in_admin'] ) ) {
        $visible = false;
    } elseif ( ( is_account_page() || $action === 'save_account_details' ) && is_user_logged_in() && ! empty( $field_args['hide_in_account'] ) ) {
        $visible = false;
    } elseif ( ( is_account_page() || $action === 'save_account_details' ) && ! is_user_logged_in() && ! empty( $field_args['hide_in_registration'] ) ) {
        $visible = false;
    } elseif ( is_checkout() && ! empty( $field_args['hide_in_checkout'] ) ) {
        $visible = false;
    }

    return $visible;
}

/**
 * Is this field core user data.
 *
 * @param $key
 *
 * @return bool
 */
function other_is_userdata( $key ) {
    $userdata = array(
        'user_pass',
        'user_login',
        'user_nicename',
        'user_url',
        'user_email',
        'display_name',
        'nickname',
        'first_name',
        'last_name',
        'description',
        'rich_editing',
        'user_registered',
        'role',
        'jabber',
        'aim',
        'yim',
        'show_admin_bar_front',
    );

    return in_array( $key, $userdata );
}

/**
 * Get user data.
 *
 * @param $user_id
 * @param $key
 * @return mixed|string
 */
function other_get_userdata( $user_id, $key ) {
    if ( ! other_is_userdata( $key ) ) {
        return get_user_meta( $user_id, $key, true );
    }

    $userdata = get_userdata( $user_id );

    if ( ! $userdata || ! isset( $userdata->{$key} ) ) {
        return '';
    }

    return $userdata->{$key};
}

add_action( 'wp_ajax_other_renew_ativation_code', 'other_renew_ativation_code' );

function other_renew_ativation_code() {


    $options                                    = get_option('other_api_settings', array());
    $other_send_subscription_api_tv_usa_login = $options['other_send_subscription_api_tv_usa_login'];
    $other_send_subscription_api_tv_usa_token = $options['other_send_subscription_api_tv_usa_token'];
    $other_send_subscription_api_url          = $options['other_send_subscription_api_url'];

    $activationCodeId = $_POST['activationCodeId'];    
    $accountNumber = $_POST['accountNumber'];
    $lastname = $_POST['lastname'];
    $json = array();

                        if($accountNumber && $accountNumber != ''){
                                write_log("Other renew activation code have a accountNumber-->$accountNumber");

                                $curl = curl_init();
                                curl_setopt($curl, CURLOPT_HEADER, false);
                                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                                curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
                                curl_setopt($curl, CURLOPT_POST, true);

                                // Get subscribers info

                                $json_data_array = array(
                                                'auth'=> array('token'=> $other_send_subscription_api_tv_usa_token , 'login'=> $other_send_subscription_api_tv_usa_login, 'accountNumber' => $accountNumber, 'lastName' => $lastname),
                                                'activationCodeId'=>$activationCodeId,
                                );
                                
                                $content = json_encode($json_data_array);
                                write_log('Other renew activation code request-->' . $content);
                                $url = $other_send_subscription_api_url . '/activationcodes/renew';

                                curl_setopt($curl, CURLOPT_URL, $url);
                                curl_setopt($curl, CURLOPT_POSTFIELDS, $content);

                                $json_response = curl_exec($curl);
                                write_log('Other renew activation code response-->' . $json_response);
                                $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                                if ( $status != 201 && $status != 200) {

                                        write_log("Other renew activation code error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

                                }else{ // Other renew activation codecall is success

                                        $response = json_decode($json_response, true);
                                        $statusCode = $response['status']['code'];
                                        $statusMessage= $response['status']['message'];

                                        if($statusCode == 0){ // Other renew activation code api call is success

                                                write_log('Other renew activation code-->' .json_encode($response["result"]));
                                                $response["result"]['expirationTime'] = date_format(date_create($response["result"]['expirationTime']), 'g:ia \o\n l jS F Y');
                                                $json = $response;

                                        }else{
                                                write_log("Other renew activation code faild with status code $statusCode and message $statusMessage");
                                        }

                                }

                        }

                        wp_send_json( $json );
}


  if (!function_exists('write_log')) {
    
    function write_log($log)
    {
        $logger = wc_get_logger();
            if (is_array($log) || is_object($log)) {
                $logger->debug(print_r($log, true), array( 'source' => 'other' ) );
            } else {
               $logger->debug($log, array( 'source' => 'other' ) );
            }
    }
    
}  
    
    
}

?>
